% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_describe_ldaps_settings}
\alias{directoryservice_describe_ldaps_settings}
\title{Describes the status of LDAP security for the specified directory}
\usage{
directoryservice_describe_ldaps_settings(DirectoryId, Type, NextToken,
  Limit)
}
\arguments{
\item{DirectoryId}{[required] The identifier of the directory.}

\item{Type}{The type of LDAP security to enable. Currently only the value \code{Client}
is supported.}

\item{NextToken}{The type of next token used for pagination.}

\item{Limit}{Specifies the number of items that should be displayed on one page.}
}
\value{
A list with the following syntax:\preformatted{list(
  LDAPSSettingsInfo = list(
    list(
      LDAPSStatus = "Enabling"|"Enabled"|"EnableFailed"|"Disabled",
      LDAPSStatusReason = "string",
      LastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the status of LDAP security for the specified directory.
}
\section{Request syntax}{
\preformatted{svc$describe_ldaps_settings(
  DirectoryId = "string",
  Type = "Client",
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
