% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_confirm_sign_up}
\alias{cognitoidentityprovider_confirm_sign_up}
\title{Confirms registration of a user and handles the existing alias from a
previous user}
\usage{
cognitoidentityprovider_confirm_sign_up(ClientId, SecretHash, Username,
  ConfirmationCode, ForceAliasCreation, AnalyticsMetadata,
  UserContextData, ClientMetadata)
}
\arguments{
\item{ClientId}{[required] The ID of the app client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{Username}{[required] The user name of the user whose registration you wish to confirm.}

\item{ConfirmationCode}{[required] The confirmation code sent by a user's request to confirm registration.}

\item{ForceAliasCreation}{Boolean to be specified to force user confirmation irrespective of
existing alias. By default set to \code{False}. If this parameter is set to
\code{True} and the phone number/email used for sign up confirmation already
exists as an alias with a different user, the API call will migrate the
alias from the previous user to the newly created user being confirmed.
If set to \code{False}, the API will throw an \strong{AliasExistsException} error.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{\link[=cognitoidentityprovider_confirm_sign_up]{confirm_sign_up}} calls.}

\item{UserContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning AWS Lambda functions to user
pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito
invokes the function that is assigned to the \emph{post confirmation}
trigger. When Amazon Cognito invokes this function, it passes a JSON
payload, which the function receives as input. This payload contains a
\code{clientMetadata} attribute, which provides the data that you assigned to
the ClientMetadata parameter in your ConfirmSignUp request. In your
function code in AWS Lambda, you can process the \code{clientMetadata} value
to enhance your workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing User Pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

Take the following limitations into consideration when you use the
ClientMetadata parameter:
\itemize{
\item Amazon Cognito does not store the ClientMetadata value. This data is
available only to AWS Lambda triggers that are assigned to a user
pool to support custom workflows. If your user pool configuration
does not include triggers, the ClientMetadata parameter serves no
purpose.
\item Amazon Cognito does not validate the ClientMetadata value.
\item Amazon Cognito does not encrypt the the ClientMetadata value, so
don't use it to provide sensitive information.
}}
}
\value{
An empty list.
}
\description{
Confirms registration of a user and handles the existing alias from a
previous user.
}
\section{Request syntax}{
\preformatted{svc$confirm_sign_up(
  ClientId = "string",
  SecretHash = "string",
  Username = "string",
  ConfirmationCode = "string",
  ForceAliasCreation = TRUE|FALSE,
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  UserContextData = list(
    EncodedData = "string"
  ),
  ClientMetadata = list(
    "string"
  )
)
}
}

\keyword{internal}
