% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_get_user}
\alias{cognitoidentityprovider_admin_get_user}
\title{Gets the specified user by user name in a user pool as an administrator}
\usage{
cognitoidentityprovider_admin_get_user(UserPoolId, Username)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to get information
about the user.}

\item{Username}{[required] The user name of the user you wish to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Username = "string",
  UserAttributes = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  UserCreateDate = as.POSIXct(
    "2015-01-01"
  ),
  UserLastModifiedDate = as.POSIXct(
    "2015-01-01"
  ),
  Enabled = TRUE|FALSE,
  UserStatus = "UNCONFIRMED"|"CONFIRMED"|"ARCHIVED"|"COMPROMISED"|"UNKNOWN"|"RESET_REQUIRED"|"FORCE_CHANGE_PASSWORD",
  MFAOptions = list(
    list(
      DeliveryMedium = "SMS"|"EMAIL",
      AttributeName = "string"
    )
  ),
  PreferredMfaSetting = "string",
  UserMFASettingList = list(
    "string"
  )
)
}
}
\description{
Gets the specified user by user name in a user pool as an administrator.
Works on any user.

Calling this action requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_get_user(
  UserPoolId = "string",
  Username = "string"
)
}
}

\keyword{internal}
