% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_update_certificate_authority}
\alias{acmpca_update_certificate_authority}
\title{Updates the status or configuration of a private certificate authority
(CA)}
\usage{
acmpca_update_certificate_authority(CertificateAuthorityArn,
  RevocationConfiguration, Status)
}
\arguments{
\item{CertificateAuthorityArn}{[required] Amazon Resource Name (ARN) of the private CA that issued the certificate
to be revoked. This must be of the form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }}

\item{RevocationConfiguration}{Revocation information for your private CA.}

\item{Status}{Status of your private CA.}
}
\value{
An empty list.
}
\description{
Updates the status or configuration of a private certificate authority
(CA). Your private CA must be in the \code{ACTIVE} or \code{DISABLED} state before
you can update it. You can disable a private CA that is in the \code{ACTIVE}
state or make a CA that is in the \code{DISABLED} state active again.

Both PCA and the IAM principal must have permission to write to the S3
bucket that you specify. If the IAM principal making the call does not
have permission to write to the bucket, then an exception is thrown. For
more information, see \href{https://docs.aws.amazon.com/acm-pca/latest/userguide/}{Configure Access to ACM Private CA}.
}
\section{Request syntax}{
\preformatted{svc$update_certificate_authority(
  CertificateAuthorityArn = "string",
  RevocationConfiguration = list(
    CrlConfiguration = list(
      Enabled = TRUE|FALSE,
      ExpirationInDays = 123,
      CustomCname = "string",
      S3BucketName = "string"
    )
  ),
  Status = "CREATING"|"PENDING_CERTIFICATE"|"ACTIVE"|"DELETED"|"DISABLED"|"EXPIRED"|"FAILED"
)
}
}

\keyword{internal}
