% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_accept_invitation}
\alias{securityhub_accept_invitation}
\title{Accepts the invitation to be a member account and be monitored by the
Security Hub master account that the invitation was sent from}
\usage{
securityhub_accept_invitation(MasterId, InvitationId)
}
\arguments{
\item{MasterId}{[required] The account ID of the Security Hub master account that sent the
invitation.}

\item{InvitationId}{[required] The ID of the invitation sent from the Security Hub master account.}
}
\value{
An empty list.
}
\description{
Accepts the invitation to be a member account and be monitored by the
Security Hub master account that the invitation was sent from.

This operation is only used by member accounts that are not added
through Organizations.

When the member account accepts the invitation, permission is granted to
the master account to view findings generated in the member account.
}
\section{Request syntax}{
\preformatted{svc$accept_invitation(
  MasterId = "string",
  InvitationId = "string"
)
}
}

\keyword{internal}
