% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitosync_operations.R
\name{cognitosync_describe_dataset}
\alias{cognitosync_describe_dataset}
\title{Gets meta data about a dataset by identity and dataset name}
\usage{
cognitosync_describe_dataset(IdentityPoolId, IdentityId, DatasetName)
}
\arguments{
\item{IdentityPoolId}{[required] A name-spaced GUID (for example,
us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
Cognito. GUID generation is unique within a region.}

\item{IdentityId}{[required] A name-spaced GUID (for example,
us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
Cognito. GUID generation is unique within a region.}

\item{DatasetName}{[required] A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9,
'_' (underscore), '-' (dash), and '.' (dot).}
}
\value{
A list with the following syntax:\preformatted{list(
  Dataset = list(
    IdentityId = "string",
    DatasetName = "string",
    CreationDate = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedBy = "string",
    DataStorage = 123,
    NumRecords = 123
  )
)
}
}
\description{
Gets meta data about a dataset by identity and dataset name. With Amazon
Cognito Sync, each identity has access only to its own data. Thus, the
credentials used to make this API call need to have access to the
identity data.

This API can be called with temporary user credentials provided by
Cognito Identity or with developer credentials. You should use Cognito
Identity credentials to make this API call.
}
\section{Request syntax}{
\preformatted{svc$describe_dataset(
  IdentityPoolId = "string",
  IdentityId = "string",
  DatasetName = "string"
)
}
}

\keyword{internal}
