% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_delete_certificate_authority}
\alias{acmpca_delete_certificate_authority}
\title{Deletes a private certificate authority (CA)}
\usage{
acmpca_delete_certificate_authority(CertificateAuthorityArn,
  PermanentDeletionTimeInDays)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}.
This must have the following form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }.}

\item{PermanentDeletionTimeInDays}{The number of days to make a CA restorable after it has been deleted.
This can be anywhere from 7 to 30 days, with 30 being the default.}
}
\value{
An empty list.
}
\description{
Deletes a private certificate authority (CA). You must provide the
Amazon Resource Name (ARN) of the private CA that you want to delete.
You can find the ARN by calling the
\code{\link[=acmpca_list_certificate_authorities]{list_certificate_authorities}}
action.

Deleting a CA will invalidate other CAs and certificates below it in
your CA hierarchy.

Before you can delete a CA that you have created and activated, you must
disable it. To do this, call the
\code{\link[=acmpca_update_certificate_authority]{update_certificate_authority}}
action and set the \strong{CertificateAuthorityStatus} parameter to
\code{DISABLED}.

Additionally, you can delete a CA if you are waiting for it to be
created (that is, the status of the CA is \code{CREATING}). You can also
delete it if the CA has been created but you haven't yet imported the
signed certificate into ACM Private CA (that is, the status of the CA is
\code{PENDING_CERTIFICATE}).

When you successfully call
\code{\link[=acmpca_delete_certificate_authority]{delete_certificate_authority}},
the CA's status changes to \code{DELETED}. However, the CA won't be
permanently deleted until the restoration period has passed. By default,
if you do not set the \code{PermanentDeletionTimeInDays} parameter, the CA
remains restorable for 30 days. You can set the parameter from 7 to 30
days. The
\code{\link[=acmpca_describe_certificate_authority]{describe_certificate_authority}}
action returns the time remaining in the restoration window of a private
CA in the \code{DELETED} state. To restore an eligible CA, call the
\code{\link[=acmpca_restore_certificate_authority]{restore_certificate_authority}}
action.
}
\section{Request syntax}{
\preformatted{svc$delete_certificate_authority(
  CertificateAuthorityArn = "string",
  PermanentDeletionTimeInDays = 123
)
}
}

\keyword{internal}
