% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_get_access_key_info}
\alias{sts_get_access_key_info}
\title{Returns the account identifier for the specified access key ID}
\usage{
sts_get_access_key_info(AccessKeyId)
}
\arguments{
\item{AccessKeyId}{[required] The identifier of an access key.

This parameter allows (through its regex pattern) a string of characters
that can consist of any upper- or lowercase letter or digit.}
}
\description{
Returns the account identifier for the specified access key ID.

Access keys consist of two parts: an access key ID (for example,
\code{AKIAIOSFODNN7EXAMPLE}) and a secret access key (for example,
\code{wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY}). For more information about
access keys, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html}{Managing Access Keys for IAM Users}
in the \emph{IAM User Guide}.

When you pass an access key ID to this operation, it returns the ID of
the AWS account to which the keys belong. Access key IDs beginning with
\code{AKIA} are long-term credentials for an IAM user or the AWS account root
user. Access key IDs beginning with \code{ASIA} are temporary credentials
that are created using STS operations. If the account in the response
belongs to you, you can sign in as the root user and review your root
user access keys. Then, you can pull a \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html}{credentials report}
to learn which IAM user owns the keys. To learn who requested the
temporary credentials for an \code{ASIA} access key, view the STS events in
your \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html}{CloudTrail logs}
in the \emph{IAM User Guide}.

This operation does not indicate the state of the access key. The key
might be active, inactive, or deleted. Active keys might not have
permissions to perform an operation. Providing a deleted access key
might return an error that the key doesn't exist.
}
\section{Request syntax}{
\preformatted{svc$get_access_key_info(
  AccessKeyId = "string"
)
}
}

\keyword{internal}
