% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_list_tags}
\alias{cloudhsmv2_list_tags}
\title{Gets a list of tags for the specified AWS CloudHSM cluster}
\usage{
cloudhsmv2_list_tags(ResourceId, NextToken, MaxResults)
}
\arguments{
\item{ResourceId}{[required] The cluster identifier (ID) for the cluster whose tags you are getting.
To find the cluster ID, use DescribeClusters.}

\item{NextToken}{The \code{NextToken} value that you received in the previous response. Use
this value to get more tags.}

\item{MaxResults}{The maximum number of tags to return in the response. When there are
more tags than the number you specify, the response contains a
\code{NextToken} value.}
}
\description{
Gets a list of tags for the specified AWS CloudHSM cluster.

This is a paginated operation, which means that each response might
contain only a subset of all the tags. When the response contains only a
subset of tags, it includes a \code{NextToken} value. Use this value in a
subsequent \code{ListTags} request to get more tags. When you receive a
response with no \code{NextToken} (or an empty or null value), that means
there are no more tags to get.
}
\section{Request syntax}{
\preformatted{svc$list_tags(
  ResourceId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
