% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_create_certificate_authority_audit_report}
\alias{acmpca_create_certificate_authority_audit_report}
\title{Creates an audit report that lists every time that your CA private key
is used}
\usage{
acmpca_create_certificate_authority_audit_report(
  CertificateAuthorityArn, S3BucketName, AuditReportResponseFormat)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) of the CA to be audited. This is of the
form:

\verb{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }.}

\item{S3BucketName}{[required] The name of the S3 bucket that will contain the audit report.}

\item{AuditReportResponseFormat}{[required] The format in which to create the report. This can be either \strong{JSON} or
\strong{CSV}.}
}
\description{
Creates an audit report that lists every time that your CA private key
is used. The report is saved in the Amazon S3 bucket that you specify on
input. The
\href{https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html}{IssueCertificate}
and
\href{https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html}{RevokeCertificate}
actions use the private key.

Both PCA and the IAM principal must have permission to write to the S3
bucket that you specify. If the IAM principal making the call does not
have permission to write to the bucket, then an exception is thrown. For
more information, see \href{https://docs.aws.amazon.com/acm-pca/latest/userguide/}{Configure Access to ACM Private CA}.

ACM Private CAA assets that are stored in Amazon S3 can be protected
with encryption. For more information, see \href{https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuditReport.html#audit-report-encryption}{Encrypting Your Audit Reports}.
}
\section{Request syntax}{
\preformatted{svc$create_certificate_authority_audit_report(
  CertificateAuthorityArn = "string",
  S3BucketName = "string",
  AuditReportResponseFormat = "JSON"|"CSV"
)
}
}

\keyword{internal}
