% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_web_acl}
\alias{wafregional_delete_web_acl}
\title{Permanently deletes a WebACL}
\usage{
wafregional_delete_web_acl(WebACLId, ChangeToken)
}
\arguments{
\item{WebACLId}{[required] The \code{WebACLId} of the WebACL that you want to delete. \code{WebACLId} is
returned by CreateWebACL and by ListWebACLs.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Permanently deletes a WebACL. You can't delete a \code{WebACL} if it still
contains any \code{Rules}.
}
\details{
To delete a \code{WebACL}, perform the following steps:
\enumerate{
\item Update the \code{WebACL} to remove \code{Rules}, if any. For more information,
see UpdateWebACL.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteWebACL} request.
\item Submit a \code{DeleteWebACL} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_web_acl(
  WebACLId = "string",
  ChangeToken = "string"
)
}
}

\examples{
# The following example deletes a web ACL with the ID
# example-46da-4444-5555-example.
\donttest{svc$delete_web_acl(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  WebACLId = "example-46da-4444-5555-example"
)}

}
\keyword{internal}
