% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_get_session_token}
\alias{sts_get_session_token}
\title{Returns a set of temporary credentials for an AWS account or IAM user}
\usage{
sts_get_session_token(DurationSeconds, SerialNumber, TokenCode)
}
\arguments{
\item{DurationSeconds}{The duration, in seconds, that the credentials should remain valid.
Acceptable durations for IAM user sessions range from 900 seconds (15
minutes) to 129600 seconds (36 hours), with 43200 seconds (12 hours) as
the default. Sessions for AWS account owners are restricted to a maximum
of 3600 seconds (one hour). If the duration is longer than one hour, the
session for AWS account owners defaults to one hour.}

\item{SerialNumber}{The identification number of the MFA device that is associated with the
IAM user who is making the \code{GetSessionToken} call. Specify this value if
the IAM user has a policy that requires MFA authentication. The value is
either the serial number for a hardware device (such as \code{GAHT12345678})
or an Amazon Resource Name (ARN) for a virtual device (such as
\code{arn:aws:iam::123456789012:mfa/user}). You can find the device for an
IAM user by going to the AWS Management Console and viewing the user's
security credentials.

The regex used to validated this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@:/-}

\item{TokenCode}{The value provided by the MFA device, if MFA is required. If any policy
requires the IAM user to submit an MFA code, specify this value. If MFA
authentication is required, and the user does not provide a code when
requesting a set of temporary security credentials, the user will
receive an "access denied" response when requesting resources that
require MFA authentication.

The format for this parameter, as described by its regex pattern, is a
sequence of six numeric digits.}
}
\description{
Returns a set of temporary credentials for an AWS account or IAM user.
The credentials consist of an access key ID, a secret access key, and a
security token. Typically, you use \code{GetSessionToken} if you want to use
MFA to protect programmatic calls to specific AWS APIs like Amazon EC2
\code{StopInstances}. MFA-enabled IAM users would need to call
\code{GetSessionToken} and submit an MFA code that is associated with their
MFA device. Using the temporary security credentials that are returned
from the call, IAM users can then make programmatic calls to APIs that
require MFA authentication. If you do not supply a correct MFA code,
then the API returns an access denied error. For a comparison of
\code{GetSessionToken} with the other APIs that produce temporary
credentials, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html}{Requesting Temporary Security Credentials}
and \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison}{Comparing the AWS STS APIs}
in the \emph{IAM User Guide}.
}
\details{
The \code{GetSessionToken} action must be called by using the long-term AWS
security credentials of the AWS account or an IAM user. Credentials that
are created by IAM users are valid for the duration that you specify,
from 900 seconds (15 minutes) up to a maximum of 129600 seconds (36
hours), with a default of 43200 seconds (12 hours); credentials that are
created by using account credentials can range from 900 seconds (15
minutes) up to a maximum of 3600 seconds (1 hour), with a default of 1
hour.

The temporary security credentials created by \code{GetSessionToken} can be
used to make API calls to any AWS service with the following exceptions:
\itemize{
\item You cannot call any IAM APIs unless MFA authentication information
is included in the request.
\item You cannot call any STS API \emph{except} \code{AssumeRole} or
\code{GetCallerIdentity}.
}

We recommend that you do not call \code{GetSessionToken} with root account
credentials. Instead, follow our \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html#create-iam-users}{best practices}
by creating one or more IAM users, giving them the necessary
permissions, and using IAM users for everyday interaction with AWS.

The permissions associated with the temporary security credentials
returned by \code{GetSessionToken} are based on the permissions associated
with account or IAM user whose credentials are used to call the action.
If \code{GetSessionToken} is called using root account credentials, the
temporary credentials have root account permissions. Similarly, if
\code{GetSessionToken} is called using the credentials of an IAM user, the
temporary credentials have the same permissions as the IAM user.

For more information about using \code{GetSessionToken} to create temporary
credentials, go to \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_getsessiontoken}{Temporary Credentials for Users in Untrusted Environments}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_session_token(
  DurationSeconds = 123,
  SerialNumber = "string",
  TokenCode = "string"
)
}
}

\examples{
# 
\donttest{svc$get_session_token(
  DurationSeconds = 3600L,
  SerialNumber = "YourMFASerialNumber",
  TokenCode = "123456"
)}

}
\keyword{internal}
