% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_get_federation_token}
\alias{sts_get_federation_token}
\title{Returns a set of temporary security credentials (consisting of an access
key ID, a secret access key, and a security token) for a federated user}
\usage{
sts_get_federation_token(Name, Policy, DurationSeconds)
}
\arguments{
\item{Name}{[required] The name of the federated user. The name is used as an identifier for
the temporary security credentials (such as \code{Bob}). For example, you can
reference the federated user name in a resource-based policy, such as in
an Amazon S3 bucket policy.

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-}

\item{Policy}{An IAM policy in JSON format that is passed with the
\code{GetFederationToken} call and evaluated along with the policy or
policies that are attached to the IAM user whose credentials are used to
call \code{GetFederationToken}. The passed policy is used to scope down the
permissions that are available to the IAM user, by allowing only a
subset of the permissions that are granted to the IAM user. The passed
policy cannot grant more permissions than those granted to the IAM user.
The final permissions for the federated user are the most restrictive
set based on the intersection of the passed policy and the IAM user
policy.

If you do not pass a policy, the resulting temporary security
credentials have no effective permissions. The only exception is when
the temporary security credentials are used to access a resource that
has a resource-based policy that specifically allows the federated user
to access the resource.

The format for this parameter, as described by its regex pattern, is a
string of characters up to 2048 characters in length. The characters can
be any ASCII character from the space character to the end of the valid
character list (\code{U+0020}-\code{U+00FF}). It can also include the tab (\code{U+0009}),
linefeed (\code{U+000A}), and carriage return (\code{U+000D}) characters.

The policy plain text must be 2048 bytes or shorter. However, an
internal conversion compresses it into a packed binary format with a
separate limit. The PackedPolicySize response element indicates by
percentage how close to the upper size limit the policy is, with 100\%
equaling the maximum allowed size.

For more information about how permissions work, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_getfederationtoken.html}{Permissions for GetFederationToken}.}

\item{DurationSeconds}{The duration, in seconds, that the session should last. Acceptable
durations for federation sessions range from 900 seconds (15 minutes) to
129600 seconds (36 hours), with 43200 seconds (12 hours) as the default.
Sessions obtained using AWS account (root) credentials are restricted to
a maximum of 3600 seconds (one hour). If the specified duration is
longer than one hour, the session obtained by using AWS account (root)
credentials defaults to one hour.}
}
\description{
Returns a set of temporary security credentials (consisting of an access
key ID, a secret access key, and a security token) for a federated user.
A typical use is in a proxy application that gets temporary security
credentials on behalf of distributed applications inside a corporate
network. Because you must call the \code{GetFederationToken} action using the
long-term security credentials of an IAM user, this call is appropriate
in contexts where those credentials can be safely stored, usually in a
server-based application. For a comparison of \code{GetFederationToken} with
the other APIs that produce temporary credentials, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html}{Requesting Temporary Security Credentials}
and \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison}{Comparing the AWS STS APIs}
in the \emph{IAM User Guide}.
}
\details{
If you are creating a mobile-based or browser-based app that can
authenticate users using a web identity provider like Login with Amazon,
Facebook, Google, or an OpenID Connect-compatible identity provider, we
recommend that you use \href{http://aws.amazon.com/cognito/}{Amazon Cognito}
or \code{AssumeRoleWithWebIdentity}. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_assumerolewithwebidentity}{Federation Through a Web-based Identity Provider}.

The \code{GetFederationToken} action must be called by using the long-term
AWS security credentials of an IAM user. You can also call
\code{GetFederationToken} using the security credentials of an AWS root
account, but we do not recommended it. Instead, we recommend that you
create an IAM user for the purpose of the proxy application and then
attach a policy to the IAM user that limits federated users to only the
actions and resources that they need access to. For more information,
see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html}{IAM Best Practices}
in the \emph{IAM User Guide}.

The temporary security credentials that are obtained by using the
long-term credentials of an IAM user are valid for the specified
duration, from 900 seconds (15 minutes) up to a maximium of 129600
seconds (36 hours). The default is 43200 seconds (12 hours). Temporary
credentials that are obtained by using AWS root account credentials have
a maximum duration of 3600 seconds (1 hour).

The temporary security credentials created by \code{GetFederationToken} can
be used to make API calls to any AWS service with the following
exceptions:
\itemize{
\item You cannot use these credentials to call any IAM APIs.
\item You cannot call any STS APIs except \code{GetCallerIdentity}.
}

\strong{Permissions}

The permissions for the temporary security credentials returned by
\code{GetFederationToken} are determined by a combination of the following:
\itemize{
\item The policy or policies that are attached to the IAM user whose
credentials are used to call \code{GetFederationToken}.
\item The policy that is passed as a parameter in the call.
}

The passed policy is attached to the temporary security credentials that
result from the \code{GetFederationToken} API call\--that is, to the
\emph{federated user}. When the federated user makes an AWS request, AWS
evaluates the policy attached to the federated user in combination with
the policy or policies attached to the IAM user whose credentials were
used to call \code{GetFederationToken}. AWS allows the federated user's
request only when both the federated user \emph{\strong{and}} the IAM user are
explicitly allowed to perform the requested action. The passed policy
cannot grant more permissions than those that are defined in the IAM
user policy.

A typical use case is that the permissions of the IAM user whose
credentials are used to call \code{GetFederationToken} are designed to allow
access to all the actions and resources that any federated user will
need. Then, for individual users, you pass a policy to the operation
that scopes down the permissions to a level that's appropriate to that
individual user, using a policy that allows only a subset of permissions
that are granted to the IAM user.

If you do not pass a policy, the resulting temporary security
credentials have no effective permissions. The only exception is when
the temporary security credentials are used to access a resource that
has a resource-based policy that specifically allows the federated user
to access the resource.

For more information about how permissions work, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_getfederationtoken.html}{Permissions for GetFederationToken}.
For information about using \code{GetFederationToken} to create temporary
security credentials, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_getfederationtoken}{GetFederationToken---Federation Through a Custom Identity Broker}.
}
\section{Request syntax}{
\preformatted{svc$get_federation_token(
  Name = "string",
  Policy = "string",
  DurationSeconds = 123
)
}
}

\examples{
# 
\donttest{svc$get_federation_token(
  DurationSeconds = 3600L,
  Name = "Bob",
  Policy = "{\\"Version\\":\\"2012-10-17\\",\\"Statement\\":[{\\"Sid\\":\\"Stmt1\\",\\"Effect\\":..."
)}

}
\keyword{internal}
