% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_put_resource_policy}
\alias{secretsmanager_put_resource_policy}
\title{Attaches the contents of the specified resource-based permission policy
to a secret}
\usage{
secretsmanager_put_resource_policy(SecretId, ResourcePolicy)
}
\arguments{
\item{SecretId}{[required] Specifies the secret that you want to attach the resource-based policy
to. You can specify either the ARN or the friendly name of the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too---for example, if you
don't include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you're
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don't create secret names
that end with a hyphen followed by six characters.}

\item{ResourcePolicy}{[required] A JSON-formatted string that's constructed according to the grammar and
syntax for an AWS resource-based policy. The policy in the string
identifies who can access or manage this secret and its versions. For
information on how to format a JSON parameter for the various command
line tool environments, see \href{http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json}{Using JSON for Parameters}
in the \emph{AWS CLI User Guide}.}
}
\description{
Attaches the contents of the specified resource-based permission policy
to a secret. A resource-based policy is optional. Alternatively, you can
use IAM identity-based policies that specify the secret's Amazon
Resource Name (ARN) in the policy statement's \code{Resources} element. You
can also use a combination of both identity-based and resource-based
policies. The affected users and roles receive the permissions that are
permitted by all of the relevant policies. For more information, see
\href{http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html}{Using Resource-Based Policies for AWS Secrets Manager}.
For the complete description of the AWS policy syntax and grammar, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html}{IAM JSON Policy Reference}
in the \emph{IAM User Guide}.
}
\details{
\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:PutResourcePolicy
}

\strong{Related operations}
\itemize{
\item To retrieve the resource policy that's attached to a secret, use
GetResourcePolicy.
\item To delete the resource-based policy that's attached to a secret,
use DeleteResourcePolicy.
\item To list all of the currently available secrets, use ListSecrets.
}
}
\section{Request syntax}{
\preformatted{svc$put_resource_policy(
  SecretId = "string",
  ResourcePolicy = "string"
)
}
}

\examples{
# The following example shows how to add a resource-based policy to a
# secret.
\donttest{svc$put_resource_policy(
  ResourcePolicy = "{\\n\\"Version\\":\\"2012-10-17\\",\\n\\"Statement\\":[{\\n\\"Effect\\":\\"Allow\\",...",
  SecretId = "MyTestDatabaseSecret"
)}

}
\keyword{internal}
