% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_decrypt}
\alias{kms_decrypt}
\title{Decrypts ciphertext}
\usage{
kms_decrypt(CiphertextBlob, EncryptionContext, GrantTokens)
}
\arguments{
\item{CiphertextBlob}{[required] Ciphertext to be decrypted. The blob includes metadata.}

\item{EncryptionContext}{The encryption context. If this was specified in the Encrypt function,
it must be specified here or the decryption operation will fail. For
more information, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html}{Encryption Context}.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Decrypts ciphertext. Ciphertext is plaintext that has been previously
encrypted by using any of the following operations:
}
\details{
\itemize{
\item GenerateDataKey
\item GenerateDataKeyWithoutPlaintext
\item Encrypt
}

Note that if a caller has been granted access permissions to all keys
(through, for example, IAM user policies that grant \code{Decrypt} permission
on all resources), then ciphertext encrypted by using keys in other
accounts where the key grants access to the caller can be decrypted. To
remedy this, we recommend that you do not grant \code{Decrypt} access in an
IAM user policy. Instead grant \code{Decrypt} access only in key policies. If
you must grant \code{Decrypt} access in an IAM user policy, you should scope
the resource to specific keys or to specific trusted accounts.

The result of this operation varies with the key state of the CMK. For
details, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$decrypt(
  CiphertextBlob = raw,
  EncryptionContext = list(
    "string"
  ),
  GrantTokens = list(
    "string"
  )
)
}
}

\examples{
# The following example decrypts data that was encrypted with a customer
# master key (CMK) in AWS KMS.
\donttest{svc$decrypt(
  CiphertextBlob = "<binary data>"
)}

}
\keyword{internal}
