% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_create_interconnect}
\alias{directconnect_create_interconnect}
\title{Creates an interconnect between an Direct Connect Partner's network and
a specific Direct Connect location}
\usage{
directconnect_create_interconnect(
  interconnectName,
  bandwidth,
  location,
  lagId = NULL,
  tags = NULL,
  providerName = NULL
)
}
\arguments{
\item{interconnectName}{[required] The name of the interconnect.}

\item{bandwidth}{[required] The port bandwidth, in Gbps. The possible values are 1 and 10.}

\item{location}{[required] The location of the interconnect.}

\item{lagId}{The ID of the LAG.}

\item{tags}{The tags to associate with the interconnect.}

\item{providerName}{The name of the service provider associated with the interconnect.}
}
\description{
Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.

See \url{https://www.paws-r-sdk.com/docs/directconnect_create_interconnect/} for full documentation.
}
\keyword{internal}
