% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_update_firewall_rule}
\alias{route53resolver_update_firewall_rule}
\title{Updates the specified firewall rule}
\usage{
route53resolver_update_firewall_rule(
  FirewallRuleGroupId,
  FirewallDomainListId,
  Priority = NULL,
  Action = NULL,
  BlockResponse = NULL,
  BlockOverrideDomain = NULL,
  BlockOverrideDnsType = NULL,
  BlockOverrideTtl = NULL,
  Name = NULL
)
}
\arguments{
\item{FirewallRuleGroupId}{[required] The unique identifier of the firewall rule group for the rule.}

\item{FirewallDomainListId}{[required] The ID of the domain list to use in the rule.}

\item{Priority}{The setting that determines the processing order of the rule in the rule
group. DNS Firewall processes the rules in a rule group by order of
priority, starting from the lowest setting.

You must specify a unique priority for each rule in a rule group. To
make it easier to insert rules later, leave space between the numbers,
for example, use 100, 200, and so on. You can change the priority
setting for the rules in a rule group at any time.}

\item{Action}{The action that DNS Firewall should take on a DNS query when it matches
one of the domains in the rule's domain list:
\itemize{
\item \code{ALLOW} - Permit the request to go through.
\item \code{ALERT} - Permit the request to go through but send an alert to the
logs.
\item \code{BLOCK} - Disallow the request. This option requires additional
details in the rule's \code{BlockResponse}.
}}

\item{BlockResponse}{The way that you want DNS Firewall to block the request. Used for the
rule action setting \code{BLOCK}.
\itemize{
\item \code{NODATA} - Respond indicating that the query was successful, but no
response is available for it.
\item \code{NXDOMAIN} - Respond indicating that the domain name that's in the
query doesn't exist.
\item \code{OVERRIDE} - Provide a custom override in the response. This option
requires custom handling details in the rule's \verb{BlockOverride*}
settings.
}}

\item{BlockOverrideDomain}{The custom DNS record to send back in response to the query. Used for
the rule action \code{BLOCK} with a \code{BlockResponse} setting of \code{OVERRIDE}.}

\item{BlockOverrideDnsType}{The DNS record's type. This determines the format of the record value
that you provided in \code{BlockOverrideDomain}. Used for the rule action
\code{BLOCK} with a \code{BlockResponse} setting of \code{OVERRIDE}.}

\item{BlockOverrideTtl}{The recommended amount of time, in seconds, for the DNS resolver or web
browser to cache the provided override record. Used for the rule action
\code{BLOCK} with a \code{BlockResponse} setting of \code{OVERRIDE}.}

\item{Name}{The name of the rule.}
}
\description{
Updates the specified firewall rule.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_rule/} for full documentation.
}
\keyword{internal}
