% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_vpc_association_authorizations}
\alias{route53_list_vpc_association_authorizations}
\title{Gets a list of the VPCs that were created by other accounts and that can
be associated with a specified hosted zone because you've submitted one
or more CreateVPCAssociationAuthorization requests}
\usage{
route53_list_vpc_association_authorizations(
  HostedZoneId,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{HostedZoneId}{[required] The ID of the hosted zone for which you want a list of VPCs that can be
associated with the hosted zone.}

\item{NextToken}{\emph{Optional}: If a response includes a \code{NextToken} element, there are more
VPCs that can be associated with the specified hosted zone. To get the
next page of results, submit another request, and include the value of
\code{NextToken} from the response in the \code{nexttoken} parameter in another
\code{\link[=route53_list_vpc_association_authorizations]{list_vpc_association_authorizations}}
request.}

\item{MaxResults}{\emph{Optional}: An integer that specifies the maximum number of VPCs that
you want Amazon Route 53 to return. If you don't specify a value for
\code{MaxResults}, Route 53 returns up to 50 VPCs per page.}
}
\description{
Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted zone because you've submitted one or more \code{\link[=route53_create_vpc_association_authorization]{create_vpc_association_authorization}} requests.

See \url{https://paws-r.github.io/docs/route53/list_vpc_association_authorizations.html} for full documentation.
}
\keyword{internal}
