# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include servicediscovery_service.R
NULL

#' Creates an HTTP namespace
#'
#' @description
#' Creates an HTTP namespace. Service instances registered using an HTTP namespace can be discovered using a [`discover_instances`][servicediscovery_discover_instances] request but can't be discovered using DNS.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/create_http_namespace.html](https://paws-r.github.io/docs/servicediscovery/create_http_namespace.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name that you want to assign to this namespace.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' [`create_http_namespace`][servicediscovery_create_http_namespace]
#' requests to be retried without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string (for example, a date/time
#' stamp).
#' @param Description A description for the namespace.
#' @param Tags The tags to add to the namespace. Each tag consists of a key and an
#' optional value that you define. Tags keys can be up to 128 characters in
#' length, and tag values can be up to 256 characters in length.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_create_http_namespace
servicediscovery_create_http_namespace <- function(Name, CreatorRequestId = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateHttpNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$create_http_namespace_input(Name = Name, CreatorRequestId = CreatorRequestId, Description = Description, Tags = Tags)
  output <- .servicediscovery$create_http_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$create_http_namespace <- servicediscovery_create_http_namespace

#' Creates a private namespace based on DNS, which is visible only inside a
#' specified Amazon VPC
#'
#' @description
#' Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. Service instances that are registered using a private DNS namespace can be discovered using either a [`discover_instances`][servicediscovery_discover_instances] request or using DNS. For the current quota on the number of namespaces that you can create using the same account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/create_private_dns_namespace.html](https://paws-r.github.io/docs/servicediscovery/create_private_dns_namespace.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name that you want to assign to this namespace. When you create a
#' private DNS namespace, Cloud Map automatically creates an Amazon Route
#' 53 private hosted zone that has the same name as the namespace.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' [`create_private_dns_namespace`][servicediscovery_create_private_dns_namespace]
#' requests to be retried without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string (for example, a
#' date/timestamp).
#' @param Description A description for the namespace.
#' @param Vpc &#91;required&#93; The ID of the Amazon VPC that you want to associate the namespace with.
#' @param Tags The tags to add to the namespace. Each tag consists of a key and an
#' optional value that you define. Tags keys can be up to 128 characters in
#' length, and tag values can be up to 256 characters in length.
#' @param Properties Properties for the private DNS namespace.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_create_private_dns_namespace
servicediscovery_create_private_dns_namespace <- function(Name, CreatorRequestId = NULL, Description = NULL, Vpc, Tags = NULL, Properties = NULL) {
  op <- new_operation(
    name = "CreatePrivateDnsNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$create_private_dns_namespace_input(Name = Name, CreatorRequestId = CreatorRequestId, Description = Description, Vpc = Vpc, Tags = Tags, Properties = Properties)
  output <- .servicediscovery$create_private_dns_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$create_private_dns_namespace <- servicediscovery_create_private_dns_namespace

#' Creates a public namespace based on DNS, which is visible on the
#' internet
#'
#' @description
#' Creates a public namespace based on DNS, which is visible on the internet. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. You can discover instances that were registered with a public DNS namespace by using either a [`discover_instances`][servicediscovery_discover_instances] request or using DNS. For the current quota on the number of namespaces that you can create using the same account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/create_public_dns_namespace.html](https://paws-r.github.io/docs/servicediscovery/create_public_dns_namespace.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name that you want to assign to this namespace.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' [`create_public_dns_namespace`][servicediscovery_create_public_dns_namespace]
#' requests to be retried without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string (for example, a
#' date/timestamp).
#' @param Description A description for the namespace.
#' @param Tags The tags to add to the namespace. Each tag consists of a key and an
#' optional value that you define. Tags keys can be up to 128 characters in
#' length, and tag values can be up to 256 characters in length.
#' @param Properties Properties for the public DNS namespace.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_create_public_dns_namespace
servicediscovery_create_public_dns_namespace <- function(Name, CreatorRequestId = NULL, Description = NULL, Tags = NULL, Properties = NULL) {
  op <- new_operation(
    name = "CreatePublicDnsNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$create_public_dns_namespace_input(Name = Name, CreatorRequestId = CreatorRequestId, Description = Description, Tags = Tags, Properties = Properties)
  output <- .servicediscovery$create_public_dns_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$create_public_dns_namespace <- servicediscovery_create_public_dns_namespace

#' Creates a service
#'
#' @description
#' Creates a service. This action defines the configuration for the following entities:
#'
#' See [https://paws-r.github.io/docs/servicediscovery/create_service.html](https://paws-r.github.io/docs/servicediscovery/create_service.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name that you want to assign to the service.
#' 
#' If you want Cloud Map to create an `SRV` record when you register an
#' instance and you're using a system that requires a specific `SRV`
#' format, such as [HAProxy](http://www.haproxy.org/), specify the
#' following for `Name`:
#' 
#' -   Start the name with an underscore (_), such as `_exampleservice`.
#' 
#' -   End the name with *._protocol*, such as `._tcp`.
#' 
#' When you register an instance, Cloud Map creates an `SRV` record and
#' assigns a name to the record by concatenating the service name and the
#' namespace name (for example,
#' 
#' `_exampleservice._tcp.example.com`).
#' 
#' For services that are accessible by DNS queries, you can't create
#' multiple services with names that differ only by case (such as EXAMPLE
#' and example). Otherwise, these services have the same DNS name and can't
#' be distinguished. However, if you use a namespace that's only accessible
#' by API calls, then you can create services that with names that differ
#' only by case.
#' @param NamespaceId The ID of the namespace that you want to use to create the service. The
#' namespace ID must be specified, but it can be specified either here or
#' in the `DnsConfig` object.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' [`create_service`][servicediscovery_create_service] requests to be
#' retried without the risk of running the operation twice.
#' `CreatorRequestId` can be any unique string (for example, a
#' date/timestamp).
#' @param Description A description for the service.
#' @param DnsConfig A complex type that contains information about the Amazon Route 53
#' records that you want Cloud Map to create when you register an instance.
#' @param HealthCheckConfig *Public DNS and HTTP namespaces only.* A complex type that contains
#' settings for an optional Route 53 health check. If you specify settings
#' for a health check, Cloud Map associates the health check with all the
#' Route 53 DNS records that you specify in `DnsConfig`.
#' 
#' If you specify a health check configuration, you can specify either
#' `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
#' 
#' For information about the charges for health checks, see [Cloud Map
#' Pricing](https://aws.amazon.com/cloud-map/pricing/).
#' @param HealthCheckCustomConfig A complex type that contains information about an optional custom health
#' check.
#' 
#' If you specify a health check configuration, you can specify either
#' `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
#' 
#' You can't add, update, or delete a `HealthCheckCustomConfig`
#' configuration from an existing service.
#' @param Tags The tags to add to the service. Each tag consists of a key and an
#' optional value that you define. Tags keys can be up to 128 characters in
#' length, and tag values can be up to 256 characters in length.
#' @param Type If present, specifies that the service instances are only discoverable
#' using the [`discover_instances`][servicediscovery_discover_instances]
#' API operation. No DNS records is registered for the service instances.
#' The only valid value is `HTTP`.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_create_service
servicediscovery_create_service <- function(Name, NamespaceId = NULL, CreatorRequestId = NULL, Description = NULL, DnsConfig = NULL, HealthCheckConfig = NULL, HealthCheckCustomConfig = NULL, Tags = NULL, Type = NULL) {
  op <- new_operation(
    name = "CreateService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$create_service_input(Name = Name, NamespaceId = NamespaceId, CreatorRequestId = CreatorRequestId, Description = Description, DnsConfig = DnsConfig, HealthCheckConfig = HealthCheckConfig, HealthCheckCustomConfig = HealthCheckCustomConfig, Tags = Tags, Type = Type)
  output <- .servicediscovery$create_service_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$create_service <- servicediscovery_create_service

#' Deletes a namespace from the current account
#'
#' @description
#' Deletes a namespace from the current account. If the namespace still contains one or more services, the request fails.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/delete_namespace.html](https://paws-r.github.io/docs/servicediscovery/delete_namespace.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the namespace that you want to delete.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_delete_namespace
servicediscovery_delete_namespace <- function(Id) {
  op <- new_operation(
    name = "DeleteNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$delete_namespace_input(Id = Id)
  output <- .servicediscovery$delete_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$delete_namespace <- servicediscovery_delete_namespace

#' Deletes a specified service
#'
#' @description
#' Deletes a specified service. If the service still contains one or more registered instances, the request fails.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/delete_service.html](https://paws-r.github.io/docs/servicediscovery/delete_service.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the service that you want to delete.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_delete_service
servicediscovery_delete_service <- function(Id) {
  op <- new_operation(
    name = "DeleteService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$delete_service_input(Id = Id)
  output <- .servicediscovery$delete_service_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$delete_service <- servicediscovery_delete_service

#' Deletes the Amazon Route 53 DNS records and health check, if any, that
#' Cloud Map created for the specified instance
#'
#' @description
#' Deletes the Amazon Route 53 DNS records and health check, if any, that Cloud Map created for the specified instance.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/deregister_instance.html](https://paws-r.github.io/docs/servicediscovery/deregister_instance.html) for full documentation.
#'
#' @param ServiceId &#91;required&#93; The ID of the service that the instance is associated with.
#' @param InstanceId &#91;required&#93; The value that you specified for `Id` in the
#' [`register_instance`][servicediscovery_register_instance] request.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_deregister_instance
servicediscovery_deregister_instance <- function(ServiceId, InstanceId) {
  op <- new_operation(
    name = "DeregisterInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$deregister_instance_input(ServiceId = ServiceId, InstanceId = InstanceId)
  output <- .servicediscovery$deregister_instance_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$deregister_instance <- servicediscovery_deregister_instance

#' Discovers registered instances for a specified namespace and service
#'
#' @description
#' Discovers registered instances for a specified namespace and service. You can use [`discover_instances`][servicediscovery_discover_instances] to discover instances for any type of namespace. For public and private DNS namespaces, you can also use DNS queries to discover instances.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/discover_instances.html](https://paws-r.github.io/docs/servicediscovery/discover_instances.html) for full documentation.
#'
#' @param NamespaceName &#91;required&#93; The `HttpName` name of the namespace. It's found in the `HttpProperties`
#' member of the `Properties` member of the namespace.
#' @param ServiceName &#91;required&#93; The name of the service that you specified when you registered the
#' instance.
#' @param MaxResults The maximum number of instances that you want Cloud Map to return in the
#' response to a
#' [`discover_instances`][servicediscovery_discover_instances] request. If
#' you don't specify a value for `MaxResults`, Cloud Map returns up to 100
#' instances.
#' @param QueryParameters Filters to scope the results based on custom attributes for the instance
#' (for example, `{version=v1, az=1a}`). Only instances that match all the
#' specified key-value pairs are returned.
#' @param OptionalParameters Opportunistic filters to scope the results based on custom attributes.
#' If there are instances that match both the filters specified in both the
#' `QueryParameters` parameter and this parameter, all of these instances
#' are returned. Otherwise, the filters are ignored, and only instances
#' that match the filters that are specified in the `QueryParameters`
#' parameter are returned.
#' @param HealthStatus The health status of the instances that you want to discover. This
#' parameter is ignored for services that don't have a health check
#' configured, and all instances are returned.
#' 
#' **HEALTHY**
#' 
#' Returns healthy instances.
#' 
#' **UNHEALTHY**
#' 
#' Returns unhealthy instances.
#' 
#' **ALL**
#' 
#' Returns all instances.
#' 
#' **HEALTHY_OR_ELSE_ALL**
#' 
#' Returns healthy instances, unless none are reporting a healthy state. In
#' that case, return all instances. This is also called failing open.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_discover_instances
servicediscovery_discover_instances <- function(NamespaceName, ServiceName, MaxResults = NULL, QueryParameters = NULL, OptionalParameters = NULL, HealthStatus = NULL) {
  op <- new_operation(
    name = "DiscoverInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$discover_instances_input(NamespaceName = NamespaceName, ServiceName = ServiceName, MaxResults = MaxResults, QueryParameters = QueryParameters, OptionalParameters = OptionalParameters, HealthStatus = HealthStatus)
  output <- .servicediscovery$discover_instances_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$discover_instances <- servicediscovery_discover_instances

#' Gets information about a specified instance
#'
#' @description
#' Gets information about a specified instance.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/get_instance.html](https://paws-r.github.io/docs/servicediscovery/get_instance.html) for full documentation.
#'
#' @param ServiceId &#91;required&#93; The ID of the service that the instance is associated with.
#' @param InstanceId &#91;required&#93; The ID of the instance that you want to get information about.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_instance
servicediscovery_get_instance <- function(ServiceId, InstanceId) {
  op <- new_operation(
    name = "GetInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_instance_input(ServiceId = ServiceId, InstanceId = InstanceId)
  output <- .servicediscovery$get_instance_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_instance <- servicediscovery_get_instance

#' Gets the current health status (Healthy, Unhealthy, or Unknown) of one
#' or more instances that are associated with a specified service
#'
#' @description
#' Gets the current health status (`Healthy`, `Unhealthy`, or `Unknown`) of one or more instances that are associated with a specified service.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/get_instances_health_status.html](https://paws-r.github.io/docs/servicediscovery/get_instances_health_status.html) for full documentation.
#'
#' @param ServiceId &#91;required&#93; The ID of the service that the instance is associated with.
#' @param Instances An array that contains the IDs of all the instances that you want to get
#' the health status for.
#' 
#' If you omit `Instances`, Cloud Map returns the health status for all the
#' instances that are associated with the specified service.
#' 
#' To get the IDs for the instances that you've registered by using a
#' specified service, submit a
#' [`list_instances`][servicediscovery_list_instances] request.
#' @param MaxResults The maximum number of instances that you want Cloud Map to return in the
#' response to a
#' [`get_instances_health_status`][servicediscovery_get_instances_health_status]
#' request. If you don't specify a value for `MaxResults`, Cloud Map
#' returns up to 100 instances.
#' @param NextToken For the first
#' [`get_instances_health_status`][servicediscovery_get_instances_health_status]
#' request, omit this value.
#' 
#' If more than `MaxResults` instances match the specified criteria, you
#' can submit another
#' [`get_instances_health_status`][servicediscovery_get_instances_health_status]
#' request to get the next group of results. Specify the value of
#' `NextToken` from the previous response in the next request.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_instances_health_status
servicediscovery_get_instances_health_status <- function(ServiceId, Instances = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetInstancesHealthStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_instances_health_status_input(ServiceId = ServiceId, Instances = Instances, MaxResults = MaxResults, NextToken = NextToken)
  output <- .servicediscovery$get_instances_health_status_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_instances_health_status <- servicediscovery_get_instances_health_status

#' Gets information about a namespace
#'
#' @description
#' Gets information about a namespace.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/get_namespace.html](https://paws-r.github.io/docs/servicediscovery/get_namespace.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the namespace that you want to get information about.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_namespace
servicediscovery_get_namespace <- function(Id) {
  op <- new_operation(
    name = "GetNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_namespace_input(Id = Id)
  output <- .servicediscovery$get_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_namespace <- servicediscovery_get_namespace

#' Gets information about any operation that returns an operation ID in the
#' response, such as a CreateService request
#'
#' @description
#' Gets information about any operation that returns an operation ID in the response, such as a [`create_service`][servicediscovery_create_service] request.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/get_operation.html](https://paws-r.github.io/docs/servicediscovery/get_operation.html) for full documentation.
#'
#' @param OperationId &#91;required&#93; The ID of the operation that you want to get more information about.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_operation
servicediscovery_get_operation <- function(OperationId) {
  op <- new_operation(
    name = "GetOperation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_operation_input(OperationId = OperationId)
  output <- .servicediscovery$get_operation_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_operation <- servicediscovery_get_operation

#' Gets the settings for a specified service
#'
#' @description
#' Gets the settings for a specified service.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/get_service.html](https://paws-r.github.io/docs/servicediscovery/get_service.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the service that you want to get settings for.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_service
servicediscovery_get_service <- function(Id) {
  op <- new_operation(
    name = "GetService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_service_input(Id = Id)
  output <- .servicediscovery$get_service_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_service <- servicediscovery_get_service

#' Lists summary information about the instances that you registered by
#' using a specified service
#'
#' @description
#' Lists summary information about the instances that you registered by using a specified service.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/list_instances.html](https://paws-r.github.io/docs/servicediscovery/list_instances.html) for full documentation.
#'
#' @param ServiceId &#91;required&#93; The ID of the service that you want to list instances for.
#' @param NextToken For the first [`list_instances`][servicediscovery_list_instances]
#' request, omit this value.
#' 
#' If more than `MaxResults` instances match the specified criteria, you
#' can submit another [`list_instances`][servicediscovery_list_instances]
#' request to get the next group of results. Specify the value of
#' `NextToken` from the previous response in the next request.
#' @param MaxResults The maximum number of instances that you want Cloud Map to return in the
#' response to a [`list_instances`][servicediscovery_list_instances]
#' request. If you don't specify a value for `MaxResults`, Cloud Map
#' returns up to 100 instances.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_instances
servicediscovery_list_instances <- function(ServiceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_instances_input(ServiceId = ServiceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicediscovery$list_instances_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_instances <- servicediscovery_list_instances

#' Lists summary information about the namespaces that were created by the
#' current account
#'
#' @description
#' Lists summary information about the namespaces that were created by the current account.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/list_namespaces.html](https://paws-r.github.io/docs/servicediscovery/list_namespaces.html) for full documentation.
#'
#' @param NextToken For the first [`list_namespaces`][servicediscovery_list_namespaces]
#' request, omit this value.
#' 
#' If the response contains `NextToken`, submit another
#' [`list_namespaces`][servicediscovery_list_namespaces] request to get the
#' next group of results. Specify the value of `NextToken` from the
#' previous response in the next request.
#' 
#' Cloud Map gets `MaxResults` namespaces and then filters them based on
#' the specified criteria. It's possible that no namespaces in the first
#' `MaxResults` namespaces matched the specified criteria but that
#' subsequent groups of `MaxResults` namespaces do contain namespaces that
#' match the criteria.
#' @param MaxResults The maximum number of namespaces that you want Cloud Map to return in
#' the response to a [`list_namespaces`][servicediscovery_list_namespaces]
#' request. If you don't specify a value for `MaxResults`, Cloud Map
#' returns up to 100 namespaces.
#' @param Filters A complex type that contains specifications for the namespaces that you
#' want to list.
#' 
#' If you specify more than one filter, a namespace must match all filters
#' to be returned by [`list_namespaces`][servicediscovery_list_namespaces].
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_namespaces
servicediscovery_list_namespaces <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListNamespaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_namespaces_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .servicediscovery$list_namespaces_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_namespaces <- servicediscovery_list_namespaces

#' Lists operations that match the criteria that you specify
#'
#' @description
#' Lists operations that match the criteria that you specify.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/list_operations.html](https://paws-r.github.io/docs/servicediscovery/list_operations.html) for full documentation.
#'
#' @param NextToken For the first [`list_operations`][servicediscovery_list_operations]
#' request, omit this value.
#' 
#' If the response contains `NextToken`, submit another
#' [`list_operations`][servicediscovery_list_operations] request to get the
#' next group of results. Specify the value of `NextToken` from the
#' previous response in the next request.
#' 
#' Cloud Map gets `MaxResults` operations and then filters them based on
#' the specified criteria. It's possible that no operations in the first
#' `MaxResults` operations matched the specified criteria but that
#' subsequent groups of `MaxResults` operations do contain operations that
#' match the criteria.
#' @param MaxResults The maximum number of items that you want Cloud Map to return in the
#' response to a [`list_operations`][servicediscovery_list_operations]
#' request. If you don't specify a value for `MaxResults`, Cloud Map
#' returns up to 100 operations.
#' @param Filters A complex type that contains specifications for the operations that you
#' want to list, for example, operations that you started between a
#' specified start date and end date.
#' 
#' If you specify more than one filter, an operation must match all filters
#' to be returned by [`list_operations`][servicediscovery_list_operations].
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_operations
servicediscovery_list_operations <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListOperations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_operations_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .servicediscovery$list_operations_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_operations <- servicediscovery_list_operations

#' Lists summary information for all the services that are associated with
#' one or more specified namespaces
#'
#' @description
#' Lists summary information for all the services that are associated with one or more specified namespaces.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/list_services.html](https://paws-r.github.io/docs/servicediscovery/list_services.html) for full documentation.
#'
#' @param NextToken For the first [`list_services`][servicediscovery_list_services] request,
#' omit this value.
#' 
#' If the response contains `NextToken`, submit another
#' [`list_services`][servicediscovery_list_services] request to get the
#' next group of results. Specify the value of `NextToken` from the
#' previous response in the next request.
#' 
#' Cloud Map gets `MaxResults` services and then filters them based on the
#' specified criteria. It's possible that no services in the first
#' `MaxResults` services matched the specified criteria but that subsequent
#' groups of `MaxResults` services do contain services that match the
#' criteria.
#' @param MaxResults The maximum number of services that you want Cloud Map to return in the
#' response to a [`list_services`][servicediscovery_list_services] request.
#' If you don't specify a value for `MaxResults`, Cloud Map returns up to
#' 100 services.
#' @param Filters A complex type that contains specifications for the namespaces that you
#' want to list services for.
#' 
#' If you specify more than one filter, an operation must match all filters
#' to be returned by [`list_services`][servicediscovery_list_services].
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_services
servicediscovery_list_services <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_services_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .servicediscovery$list_services_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_services <- servicediscovery_list_services

#' Lists tags for the specified resource
#'
#' @description
#' Lists tags for the specified resource.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/list_tags_for_resource.html](https://paws-r.github.io/docs/servicediscovery/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to retrieve
#' tags for.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_tags_for_resource
servicediscovery_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .servicediscovery$list_tags_for_resource_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_tags_for_resource <- servicediscovery_list_tags_for_resource

#' Creates or updates one or more records and, optionally, creates a health
#' check based on the settings in a specified service
#'
#' @description
#' Creates or updates one or more records and, optionally, creates a health check based on the settings in a specified service. When you submit a [`register_instance`][servicediscovery_register_instance] request, the following occurs:
#'
#' See [https://paws-r.github.io/docs/servicediscovery/register_instance.html](https://paws-r.github.io/docs/servicediscovery/register_instance.html) for full documentation.
#'
#' @param ServiceId &#91;required&#93; The ID of the service that you want to use for settings for the
#' instance.
#' @param InstanceId &#91;required&#93; An identifier that you want to associate with the instance. Note the
#' following:
#' 
#' -   If the service that's specified by `ServiceId` includes settings for
#'     an `SRV` record, the value of `InstanceId` is automatically included
#'     as part of the value for the `SRV` record. For more information, see
#'     [DnsRecord \>
#'     Type](https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type).
#' 
#' -   You can use this value to update an existing instance.
#' 
#' -   To register a new instance, you must specify a value that's unique
#'     among instances that you register by using the same service.
#' 
#' -   If you specify an existing `InstanceId` and `ServiceId`, Cloud Map
#'     updates the existing DNS records, if any. If there's also an
#'     existing health check, Cloud Map deletes the old health check and
#'     creates a new one.
#' 
#'     The health check isn't deleted immediately, so it will still appear
#'     for a while if you submit a `ListHealthChecks` request, for example.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' [`register_instance`][servicediscovery_register_instance] requests to be
#' retried without the risk of executing the operation twice. You must use
#' a unique `CreatorRequestId` string every time you submit a
#' [`register_instance`][servicediscovery_register_instance] request if
#' you're registering additional instances for the same namespace and
#' service. `CreatorRequestId` can be any unique string (for example, a
#' date/time stamp).
#' @param Attributes &#91;required&#93; A string map that contains the following information for the service
#' that you specify in `ServiceId`:
#' 
#' -   The attributes that apply to the records that are defined in the
#'     service.
#' 
#' -   For each attribute, the applicable value.
#' 
#' Supported attribute keys include the following:
#' 
#' **AWS_ALIAS_DNS_NAME**
#' 
#' If you want Cloud Map to create an Amazon Route 53 alias record that
#' routes traffic to an Elastic Load Balancing load balancer, specify the
#' DNS name that's associated with the load balancer. For information about
#' how to get the DNS name, see "DNSName" in the topic
#' [AliasTarget](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html)
#' in the *Route 53 API Reference*.
#' 
#' Note the following:
#' 
#' -   The configuration for the service that's specified by `ServiceId`
#'     must include settings for an `A` record, an `AAAA` record, or both.
#' 
#' -   In the service that's specified by `ServiceId`, the value of
#'     `RoutingPolicy` must be `WEIGHTED`.
#' 
#' -   If the service that's specified by `ServiceId` includes
#'     `HealthCheckConfig` settings, Cloud Map will create the Route 53
#'     health check, but it doesn't associate the health check with the
#'     alias record.
#' 
#' -   Auto naming currently doesn't support creating alias records that
#'     route traffic to Amazon Web Services resources other than Elastic
#'     Load Balancing load balancers.
#' 
#' -   If you specify a value for `AWS_ALIAS_DNS_NAME`, don't specify
#'     values for any of the `AWS_INSTANCE` attributes.
#' 
#' **AWS_EC2_INSTANCE_ID**
#' 
#' *HTTP namespaces only.* The Amazon EC2 instance ID for the instance. If
#' the `AWS_EC2_INSTANCE_ID` attribute is specified, then the only other
#' attribute that can be specified is `AWS_INIT_HEALTH_STATUS`. When the
#' `AWS_EC2_INSTANCE_ID` attribute is specified, then the
#' `AWS_INSTANCE_IPV4` attribute will be filled out with the primary
#' private IPv4 address.
#' 
#' **AWS_INIT_HEALTH_STATUS**
#' 
#' If the service configuration includes `HealthCheckCustomConfig`, you can
#' optionally use `AWS_INIT_HEALTH_STATUS` to specify the initial status of
#' the custom health check, `HEALTHY` or `UNHEALTHY`. If you don't specify
#' a value for `AWS_INIT_HEALTH_STATUS`, the initial status is `HEALTHY`.
#' 
#' **AWS_INSTANCE_CNAME**
#' 
#' If the service configuration includes a `CNAME` record, the domain name
#' that you want Route 53 to return in response to DNS queries (for
#' example, `example.com`).
#' 
#' This value is required if the service specified by `ServiceId` includes
#' settings for an `CNAME` record.
#' 
#' **AWS_INSTANCE_IPV4**
#' 
#' If the service configuration includes an `A` record, the IPv4 address
#' that you want Route 53 to return in response to DNS queries (for
#' example, `192.0.2.44`).
#' 
#' This value is required if the service specified by `ServiceId` includes
#' settings for an `A` record. If the service includes settings for an
#' `SRV` record, you must specify a value for `AWS_INSTANCE_IPV4`,
#' `AWS_INSTANCE_IPV6`, or both.
#' 
#' **AWS_INSTANCE_IPV6**
#' 
#' If the service configuration includes an `AAAA` record, the IPv6 address
#' that you want Route 53 to return in response to DNS queries (for
#' example, `2001:0db8:85a3:0000:0000:abcd:0001:2345`).
#' 
#' This value is required if the service specified by `ServiceId` includes
#' settings for an `AAAA` record. If the service includes settings for an
#' `SRV` record, you must specify a value for `AWS_INSTANCE_IPV4`,
#' `AWS_INSTANCE_IPV6`, or both.
#' 
#' **AWS_INSTANCE_PORT**
#' 
#' If the service includes an `SRV` record, the value that you want Route
#' 53 to return for the port.
#' 
#' If the service includes `HealthCheckConfig`, the port on the endpoint
#' that you want Route 53 to send requests to.
#' 
#' This value is required if you specified settings for an `SRV` record or
#' a Route 53 health check when you created the service.
#' 
#' **Custom attributes**
#' 
#' You can add up to 30 custom attributes. For each key-value pair, the
#' maximum length of the attribute name is 255 characters, and the maximum
#' length of the attribute value is 1,024 characters. The total size of all
#' provided attributes (sum of all keys and values) must not exceed 5,000
#' characters.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_register_instance
servicediscovery_register_instance <- function(ServiceId, InstanceId, CreatorRequestId = NULL, Attributes) {
  op <- new_operation(
    name = "RegisterInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$register_instance_input(ServiceId = ServiceId, InstanceId = InstanceId, CreatorRequestId = CreatorRequestId, Attributes = Attributes)
  output <- .servicediscovery$register_instance_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$register_instance <- servicediscovery_register_instance

#' Adds one or more tags to the specified resource
#'
#' @description
#' Adds one or more tags to the specified resource.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/tag_resource.html](https://paws-r.github.io/docs/servicediscovery/tag_resource.html) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to retrieve
#' tags for.
#' @param Tags &#91;required&#93; The tags to add to the specified resource. Specifying the tag key is
#' required. You can set the value of a tag to an empty string, but you
#' can't set the value of a tag to null.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_tag_resource
servicediscovery_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .servicediscovery$tag_resource_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$tag_resource <- servicediscovery_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/untag_resource.html](https://paws-r.github.io/docs/servicediscovery/untag_resource.html) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to retrieve
#' tags for.
#' @param TagKeys &#91;required&#93; The tag keys to remove from the specified resource.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_untag_resource
servicediscovery_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .servicediscovery$untag_resource_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$untag_resource <- servicediscovery_untag_resource

#' Updates an HTTP namespace
#'
#' @description
#' Updates an HTTP namespace.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/update_http_namespace.html](https://paws-r.github.io/docs/servicediscovery/update_http_namespace.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the namespace that you want to update.
#' @param UpdaterRequestId A unique string that identifies the request and that allows failed
#' [`update_http_namespace`][servicediscovery_update_http_namespace]
#' requests to be retried without the risk of running the operation twice.
#' `UpdaterRequestId` can be any unique string (for example, a
#' date/timestamp).
#' @param Namespace &#91;required&#93; Updated properties for the the HTTP namespace.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_update_http_namespace
servicediscovery_update_http_namespace <- function(Id, UpdaterRequestId = NULL, Namespace) {
  op <- new_operation(
    name = "UpdateHttpNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$update_http_namespace_input(Id = Id, UpdaterRequestId = UpdaterRequestId, Namespace = Namespace)
  output <- .servicediscovery$update_http_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$update_http_namespace <- servicediscovery_update_http_namespace

#' Submits a request to change the health status of a custom health check
#' to healthy or unhealthy
#'
#' @description
#' Submits a request to change the health status of a custom health check to healthy or unhealthy.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/update_instance_custom_health_status.html](https://paws-r.github.io/docs/servicediscovery/update_instance_custom_health_status.html) for full documentation.
#'
#' @param ServiceId &#91;required&#93; The ID of the service that includes the configuration for the custom
#' health check that you want to change the status for.
#' @param InstanceId &#91;required&#93; The ID of the instance that you want to change the health status for.
#' @param Status &#91;required&#93; The new status of the instance, `HEALTHY` or `UNHEALTHY`.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_update_instance_custom_health_status
servicediscovery_update_instance_custom_health_status <- function(ServiceId, InstanceId, Status) {
  op <- new_operation(
    name = "UpdateInstanceCustomHealthStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$update_instance_custom_health_status_input(ServiceId = ServiceId, InstanceId = InstanceId, Status = Status)
  output <- .servicediscovery$update_instance_custom_health_status_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$update_instance_custom_health_status <- servicediscovery_update_instance_custom_health_status

#' Updates a private DNS namespace
#'
#' @description
#' Updates a private DNS namespace.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/update_private_dns_namespace.html](https://paws-r.github.io/docs/servicediscovery/update_private_dns_namespace.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the namespace that you want to update.
#' @param UpdaterRequestId A unique string that identifies the request and that allows failed
#' [`update_private_dns_namespace`][servicediscovery_update_private_dns_namespace]
#' requests to be retried without the risk of running the operation twice.
#' `UpdaterRequestId` can be any unique string (for example, a
#' date/timestamp).
#' @param Namespace &#91;required&#93; Updated properties for the private DNS namespace.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_update_private_dns_namespace
servicediscovery_update_private_dns_namespace <- function(Id, UpdaterRequestId = NULL, Namespace) {
  op <- new_operation(
    name = "UpdatePrivateDnsNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$update_private_dns_namespace_input(Id = Id, UpdaterRequestId = UpdaterRequestId, Namespace = Namespace)
  output <- .servicediscovery$update_private_dns_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$update_private_dns_namespace <- servicediscovery_update_private_dns_namespace

#' Updates a public DNS namespace
#'
#' @description
#' Updates a public DNS namespace.
#'
#' See [https://paws-r.github.io/docs/servicediscovery/update_public_dns_namespace.html](https://paws-r.github.io/docs/servicediscovery/update_public_dns_namespace.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the namespace being updated.
#' @param UpdaterRequestId A unique string that identifies the request and that allows failed
#' [`update_public_dns_namespace`][servicediscovery_update_public_dns_namespace]
#' requests to be retried without the risk of running the operation twice.
#' `UpdaterRequestId` can be any unique string (for example, a
#' date/timestamp).
#' @param Namespace &#91;required&#93; Updated properties for the public DNS namespace.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_update_public_dns_namespace
servicediscovery_update_public_dns_namespace <- function(Id, UpdaterRequestId = NULL, Namespace) {
  op <- new_operation(
    name = "UpdatePublicDnsNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$update_public_dns_namespace_input(Id = Id, UpdaterRequestId = UpdaterRequestId, Namespace = Namespace)
  output <- .servicediscovery$update_public_dns_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$update_public_dns_namespace <- servicediscovery_update_public_dns_namespace

#' Submits a request to perform the following operations:
#'
#' @description
#' Submits a request to perform the following operations:
#'
#' See [https://paws-r.github.io/docs/servicediscovery/update_service.html](https://paws-r.github.io/docs/servicediscovery/update_service.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the service that you want to update.
#' @param Service &#91;required&#93; A complex type that contains the new settings for the service.
#'
#' @keywords internal
#'
#' @rdname servicediscovery_update_service
servicediscovery_update_service <- function(Id, Service) {
  op <- new_operation(
    name = "UpdateService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$update_service_input(Id = Id, Service = Service)
  output <- .servicediscovery$update_service_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$update_service <- servicediscovery_update_service
