% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_hosted_zones_by_name}
\alias{route53_list_hosted_zones_by_name}
\title{Retrieves a list of your hosted zones in lexicographic order}
\usage{
route53_list_hosted_zones_by_name(DNSName, HostedZoneId, MaxItems)
}
\arguments{
\item{DNSName}{(Optional) For your first request to \code{ListHostedZonesByName}, include
the \code{dnsname} parameter only if you want to specify the name of the
first hosted zone in the response. If you don\'t include the \code{dnsname}
parameter, Amazon Route 53 returns all of the hosted zones that were
created by the current AWS account, in ASCII order. For subsequent
requests, include both \code{dnsname} and \code{hostedzoneid} parameters. For
\code{dnsname}, specify the value of \code{NextDNSName} from the previous
response.}

\item{HostedZoneId}{(Optional) For your first request to \code{ListHostedZonesByName}, do not
include the \code{hostedzoneid} parameter.

If you have more hosted zones than the value of \code{maxitems},
\code{ListHostedZonesByName} returns only the first \code{maxitems} hosted zones.
To get the next group of \code{maxitems} hosted zones, submit another request
to \code{ListHostedZonesByName} and include both \code{dnsname} and \code{hostedzoneid}
parameters. For the value of \code{hostedzoneid}, specify the value of the
\code{NextHostedZoneId} element from the previous response.}

\item{MaxItems}{The maximum number of hosted zones to be included in the response body
for this request. If you have more than \code{maxitems} hosted zones, then
the value of the \code{IsTruncated} element in the response is true, and the
values of \code{NextDNSName} and \code{NextHostedZoneId} specify the first hosted
zone in the next group of \code{maxitems} hosted zones.}
}
\description{
Retrieves a list of your hosted zones in lexicographic order. The
response includes a \code{HostedZones} child element for each hosted zone
created by the current AWS account.
}
\details{
\code{ListHostedZonesByName} sorts hosted zones by name with the labels
reversed. For example:

\code{com.example.www.}

Note the trailing dot, which can change the sort order in some
circumstances.

If the domain name includes escape characters or Punycode,
\code{ListHostedZonesByName} alphabetizes the domain name using the escaped
or Punycoded value, which is the format that Amazon Route 53 saves in
its database. For example, to create a hosted zone for exÃ¤mple.com, you
specify ex\\344mple.com for the domain name. \code{ListHostedZonesByName}
alphabetizes it as:

\verb{com.ex\\\\344mple.}

The labels are reversed and alphabetized using the escaped value. For
more information about valid domain name formats, including
internationalized domain names, see \href{https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html}{DNS Domain Name Format}
in the \emph{Amazon Route 53 Developer Guide}.

Route 53 returns up to 100 items in each response. If you have a lot of
hosted zones, use the \code{MaxItems} parameter to list them in groups of up
to 100. The response includes values that help navigate from one group
of \code{MaxItems} hosted zones to the next:
\itemize{
\item The \code{DNSName} and \code{HostedZoneId} elements in the response contain
the values, if any, specified for the \code{dnsname} and \code{hostedzoneid}
parameters in the request that produced the current response.
\item The \code{MaxItems} element in the response contains the value, if any,
that you specified for the \code{maxitems} parameter in the request that
produced the current response.
\item If the value of \code{IsTruncated} in the response is true, there are
more hosted zones associated with the current AWS account.

If \code{IsTruncated} is false, this response includes the last hosted
zone that is associated with the current account. The \code{NextDNSName}
element and \code{NextHostedZoneId} elements are omitted from the
response.
\item The \code{NextDNSName} and \code{NextHostedZoneId} elements in the response
contain the domain name and the hosted zone ID of the next hosted
zone that is associated with the current AWS account. If you want to
list more hosted zones, make another call to
\code{ListHostedZonesByName}, and specify the value of \code{NextDNSName} and
\code{NextHostedZoneId} in the \code{dnsname} and \code{hostedzoneid} parameters,
respectively.
}
}
\section{Request syntax}{
\preformatted{svc$list_hosted_zones_by_name(
  DNSName = "string",
  HostedZoneId = "string",
  MaxItems = "string"
)
}
}

\keyword{internal}
