% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_delete_gateway_route}
\alias{appmesh_delete_gateway_route}
\title{Deletes an existing gateway route}
\usage{
appmesh_delete_gateway_route(gatewayRouteName, meshName, meshOwner,
  virtualGatewayName)
}
\arguments{
\item{gatewayRouteName}{[required] The name of the gateway route to delete.}

\item{meshName}{[required] The name of the service mesh to delete the gateway route from.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it\'s the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{virtualGatewayName}{[required] The name of the virtual gateway to delete the route from.}
}
\description{
Deletes an existing gateway route.
}
\section{Request syntax}{
\preformatted{svc$delete_gateway_route(
  gatewayRouteName = "string",
  meshName = "string",
  meshOwner = "string",
  virtualGatewayName = "string"
)
}
}

\keyword{internal}
