% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_distributions_by_realtime_log_config}
\alias{cloudfront_list_distributions_by_realtime_log_config}
\title{Gets a list of distributions that have a cache behavior that’s
associated with the specified real-time log configuration}
\usage{
cloudfront_list_distributions_by_realtime_log_config(Marker, MaxItems,
  RealtimeLogConfigName, RealtimeLogConfigArn)
}
\arguments{
\item{Marker}{Use this field when paginating results to indicate where to begin in
your list of distributions. The response includes distributions in the
list that occur after the marker. To get the next page of the list, set
this field’s value to the value of \code{NextMarker} from the current page’s
response.}

\item{MaxItems}{The maximum number of distributions that you want in the response.}

\item{RealtimeLogConfigName}{The name of the real-time log configuration whose associated
distributions you want to list.}

\item{RealtimeLogConfigArn}{The Amazon Resource Name (ARN) of the real-time log configuration whose
associated distributions you want to list.}
}
\description{
Gets a list of distributions that have a cache behavior that’s
associated with the specified real-time log configuration.

You can specify the real-time log configuration by its name or its
Amazon Resource Name (ARN). You must provide at least one. If you
provide both, CloudFront uses the name to identify the real-time log
configuration to list distributions for.

You can optionally specify the maximum number of items to receive in the
response. If the total number of items in the list exceeds the maximum
that you specify, or the default maximum, the response is paginated. To
get the next page of items, send a subsequent request that specifies the
\code{NextMarker} value from the current response as the \code{Marker} value in
the subsequent request.
}
\section{Request syntax}{
\preformatted{svc$list_distributions_by_realtime_log_config(
  Marker = "string",
  MaxItems = "string",
  RealtimeLogConfigName = "string",
  RealtimeLogConfigArn = "string"
)
}
}

\keyword{internal}
