% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_model}
\alias{apigateway_create_model}
\title{Adds a new Model resource to an existing RestApi resource}
\usage{
apigateway_create_model(restApiId, name, description, schema,
  contentType)
}
\arguments{
\item{restApiId}{[required] [Required] The RestApi identifier under which the Model will be
created.}

\item{name}{[required] [Required] The name of the model. Must be alphanumeric.}

\item{description}{The description of the model.}

\item{schema}{The schema for the model. For \code{application/json} models, this should be
\href{https://tools.ietf.org/html/draft-zyp-json-schema-04}{JSON schema draft 4} model.}

\item{contentType}{[required] [Required] The content-type for the model.}
}
\description{
Adds a new Model resource to an existing RestApi resource.
}
\section{Request syntax}{
\preformatted{svc$create_model(
  restApiId = "string",
  name = "string",
  description = "string",
  schema = "string",
  contentType = "string"
)
}
}

\keyword{internal}
