% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_create_kx_changeset}
\alias{finspace_create_kx_changeset}
\title{Creates a changeset for a kdb database}
\usage{
finspace_create_kx_changeset(
  environmentId,
  databaseName,
  changeRequests,
  clientToken
)
}
\arguments{
\item{environmentId}{[required] A unique identifier of the kdb environment.}

\item{databaseName}{[required] The name of the kdb database.}

\item{changeRequests}{[required] A list of change request objects that are run in order. A change request
object consists of changeType , s3Path, and a dbPath. A changeType can
has the following values:
\itemize{
\item PUT – Adds or updates files in a database.
\item DELETE – Deletes files in a database.
}

All the change requests require a mandatory \emph{dbPath} attribute that
defines the path within the database directory. The \emph{s3Path} attribute
defines the s3 source file path and is required for a PUT change type.

Here is an example of how you can use the change request object:

\verb{[ \{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"\}, \{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"\}, \{ "changeType": "DELETE", "dbPath": "/2020.01.01/"\} ]}

In this example, the first request with \emph{PUT} change type allows you to
add files in the given s3Path under the \emph{2020.01.02} partition of the
database. The second request with \emph{PUT} change type allows you to add a
single sym file at database root location. The last request with
\emph{DELETE} change type allows you to delete the files under the
\emph{2020.01.01} partition of the database.}

\item{clientToken}{[required] A token that ensures idempotency. This token expires in 10 minutes.}
}
\description{
Creates a changeset for a kdb database. A changeset allows you to add and delete existing files by using an ordered list of change requests.

See \url{https://www.paws-r-sdk.com/docs/finspace_create_kx_changeset/} for full documentation.
}
\keyword{internal}
