# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include resourcegroupstaggingapi_service.R
NULL

#' Describes the status of the StartReportCreation operation
#'
#' @description
#' Describes the status of the [`start_report_creation`][resourcegroupstaggingapi_start_report_creation] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_describe_report_creation/](https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_describe_report_creation/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_describe_report_creation
resourcegroupstaggingapi_describe_report_creation <- function() {
  op <- new_operation(
    name = "DescribeReportCreation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .resourcegroupstaggingapi$describe_report_creation_input()
  output <- .resourcegroupstaggingapi$describe_report_creation_output()
  config <- get_config()
  svc <- .resourcegroupstaggingapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$describe_report_creation <- resourcegroupstaggingapi_describe_report_creation

#' Returns a table that shows counts of resources that are noncompliant
#' with their tag policies
#'
#' @description
#' Returns a table that shows counts of resources that are noncompliant with their tag policies.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_get_compliance_summary/](https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_get_compliance_summary/) for full documentation.
#'
#' @param TargetIdFilters Specifies target identifiers (usually, specific account IDs) to limit
#' the output by. If you use this parameter, the count of returned
#' noncompliant resources includes only resources with the specified target
#' IDs.
#' @param RegionFilters Specifies a list of Amazon Web Services Regions to limit the output to.
#' If you use this parameter, the count of returned noncompliant resources
#' includes only resources in the specified Regions.
#' @param ResourceTypeFilters Specifies that you want the response to include information for only
#' resources of the specified types. The format of each resource type is
#' `service[:resourceType]`. For example, specifying a resource type of
#' `ec2` returns all Amazon EC2 resources (which includes EC2 instances).
#' Specifying a resource type of `ec2:instance` returns only EC2 instances.
#' 
#' The string for each service name and resource type is the same as that
#' embedded in a resource's Amazon Resource Name (ARN). Consult the *\href{https://docs.aws.amazon.com/general/latest/gr/}{Amazon Web Services General Reference}* for the following:
#' 
#' -   For a list of service name strings, see [Amazon Web Services Service
#'     Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#genref-aws-service-namespaces).
#' 
#' -   For resource type strings, see [Example
#'     ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arns-syntax).
#' 
#' -   For more information about ARNs, see [Amazon Resource Names (ARNs)
#'     and Amazon Web Services Service
#'     Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#' 
#' You can specify multiple resource types by using a comma separated
#' array. The array can include up to 100 items. Note that the length
#' constraint requirement applies to each resource type filter.
#' @param TagKeyFilters Specifies that you want the response to include information for only
#' resources that have tags with the specified tag keys. If you use this
#' parameter, the count of returned noncompliant resources includes only
#' resources that have the specified tag keys.
#' @param GroupBy Specifies a list of attributes to group the counts of noncompliant
#' resources by. If supplied, the counts are sorted by those attributes.
#' @param MaxResults Specifies the maximum number of results to be returned in each page. A
#' query can return fewer than this maximum, even if there are more results
#' still to return. You should always check the `PaginationToken` response
#' value to see if there are more results. You can specify a minimum of 1
#' and a maximum value of 100.
#' @param PaginationToken Specifies a `PaginationToken` response value from a previous request to
#' indicate that you want the next page of results. Leave this parameter
#' empty in your initial request.
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_get_compliance_summary
resourcegroupstaggingapi_get_compliance_summary <- function(TargetIdFilters = NULL, RegionFilters = NULL, ResourceTypeFilters = NULL, TagKeyFilters = NULL, GroupBy = NULL, MaxResults = NULL, PaginationToken = NULL) {
  op <- new_operation(
    name = "GetComplianceSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PaginationToken", limit_key = "MaxResults", output_token = "PaginationToken", result_key = "SummaryList")
  )
  input <- .resourcegroupstaggingapi$get_compliance_summary_input(TargetIdFilters = TargetIdFilters, RegionFilters = RegionFilters, ResourceTypeFilters = ResourceTypeFilters, TagKeyFilters = TagKeyFilters, GroupBy = GroupBy, MaxResults = MaxResults, PaginationToken = PaginationToken)
  output <- .resourcegroupstaggingapi$get_compliance_summary_output()
  config <- get_config()
  svc <- .resourcegroupstaggingapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$get_compliance_summary <- resourcegroupstaggingapi_get_compliance_summary

#' Returns all the tagged or previously tagged resources that are located
#' in the specified Amazon Web Services Region for the account
#'
#' @description
#' Returns all the tagged or previously tagged resources that are located in the specified Amazon Web Services Region for the account.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_get_resources/](https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_get_resources/) for full documentation.
#'
#' @param PaginationToken Specifies a `PaginationToken` response value from a previous request to
#' indicate that you want the next page of results. Leave this parameter
#' empty in your initial request.
#' @param TagFilters Specifies a list of TagFilters (keys and values) to restrict the output
#' to only those resources that have tags with the specified keys and, if
#' included, the specified values. Each `TagFilter` must contain a key with
#' values optional. A request can include up to 50 keys, and each key can
#' include up to 20 values.
#' 
#' Note the following when deciding how to use TagFilters:
#' 
#' -   If you *don't* specify a `TagFilter`, the response includes all
#'     resources that are currently tagged or ever had a tag. Resources
#'     that currently don't have tags are shown with an empty tag set, like
#'     this: `"Tags": []`.
#' 
#' -   If you specify more than one filter in a single request, the
#'     response returns only those resources that satisfy all filters.
#' 
#' -   If you specify a filter that contains more than one value for a key,
#'     the response returns resources that match *any* of the specified
#'     values for that key.
#' 
#' -   If you don't specify a value for a key, the response returns all
#'     resources that are tagged with that key, with any or no value.
#' 
#'     For example, for the following filters: `filter1= {keyA,{value1}}`,
#'     `filter2={keyB,{value2,value3,value4}}`, `filter3= {keyC}`:
#' 
#'     -   `GetResources({filter1})` returns resources tagged with
#'         `key1=value1`
#' 
#'     -   `GetResources({filter2})` returns resources tagged with
#'         `key2=value2` or `key2=value3` or `key2=value4`
#' 
#'     -   `GetResources({filter3})` returns resources tagged with any tag
#'         with the key `key3`, and with any or no value
#' 
#'     -   `GetResources({filter1,filter2,filter3})` returns resources
#'         tagged with
#'         `(key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or no value)`
#' @param ResourcesPerPage Specifies the maximum number of results to be returned in each page. A
#' query can return fewer than this maximum, even if there are more results
#' still to return. You should always check the `PaginationToken` response
#' value to see if there are more results. You can specify a minimum of 1
#' and a maximum value of 100.
#' @param TagsPerPage Amazon Web Services recommends using `ResourcesPerPage` instead of this
#' parameter.
#' 
#' A limit that restricts the number of tags (key and value pairs) returned
#' by [`get_resources`][resourcegroupstaggingapi_get_resources] in
#' paginated output. A resource with no tags is counted as having one tag
#' (one key and value pair).
#' 
#' [`get_resources`][resourcegroupstaggingapi_get_resources] does not split
#' a resource and its associated tags across pages. If the specified
#' `TagsPerPage` would cause such a break, a `PaginationToken` is returned
#' in place of the affected resource and its tags. Use that token in
#' another request to get the remaining data. For example, if you specify a
#' `TagsPerPage` of `100` and the account has 22 resources with 10 tags
#' each (meaning that each resource has 10 key and value pairs), the output
#' will consist of three pages. The first page displays the first 10
#' resources, each with its 10 tags. The second page displays the next 10
#' resources, each with its 10 tags. The third page displays the remaining
#' 2 resources, each with its 10 tags.
#' 
#' You can set `TagsPerPage` to a minimum of 100 items up to a maximum of
#' 500 items.
#' @param ResourceTypeFilters Specifies the resource types that you want included in the response. The
#' format of each resource type is `service[:resourceType]`. For example,
#' specifying a resource type of `ec2` returns all Amazon EC2 resources
#' (which includes EC2 instances). Specifying a resource type of
#' `ec2:instance` returns only EC2 instances.
#' 
#' The string for each service name and resource type is the same as that
#' embedded in a resource's Amazon Resource Name (ARN). For the list of
#' services whose resources you can use in this parameter, see [Services
#' that support the Resource Groups Tagging
#' API](https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html).
#' 
#' You can specify multiple resource types by using an array. The array can
#' include up to 100 items. Note that the length constraint requirement
#' applies to each resource type filter. For example, the following string
#' would limit the response to only Amazon EC2 instances, Amazon S3
#' buckets, or any Audit Manager resource:
#' 
#' `ec2:instance,s3:bucket,auditmanager`
#' @param IncludeComplianceDetails Specifies whether to include details regarding the compliance with the
#' effective tag policy. Set this to `true` to determine whether resources
#' are compliant with the tag policy and to get details.
#' @param ExcludeCompliantResources Specifies whether to exclude resources that are compliant with the tag
#' policy. Set this to `true` if you are interested in retrieving
#' information on noncompliant resources only.
#' 
#' You can use this parameter only if the `IncludeComplianceDetails`
#' parameter is also set to `true`.
#' @param ResourceARNList Specifies a list of ARNs of resources for which you want to retrieve tag
#' data. You can't specify both this parameter and any of the pagination
#' parameters (`ResourcesPerPage`, `TagsPerPage`, `PaginationToken`) in the
#' same request. If you specify both, you get an `Invalid Parameter`
#' exception.
#' 
#' If a resource specified by this parameter doesn't exist, it doesn't
#' generate an error; it simply isn't included in the response.
#' 
#' An ARN (Amazon Resource Name) uniquely identifies a resource. For more
#' information, see [Amazon Resource Names (ARNs) and Amazon Web Services
#' Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_get_resources
resourcegroupstaggingapi_get_resources <- function(PaginationToken = NULL, TagFilters = NULL, ResourcesPerPage = NULL, TagsPerPage = NULL, ResourceTypeFilters = NULL, IncludeComplianceDetails = NULL, ExcludeCompliantResources = NULL, ResourceARNList = NULL) {
  op <- new_operation(
    name = "GetResources",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PaginationToken", limit_key = "ResourcesPerPage", output_token = "PaginationToken", result_key = "ResourceTagMappingList")
  )
  input <- .resourcegroupstaggingapi$get_resources_input(PaginationToken = PaginationToken, TagFilters = TagFilters, ResourcesPerPage = ResourcesPerPage, TagsPerPage = TagsPerPage, ResourceTypeFilters = ResourceTypeFilters, IncludeComplianceDetails = IncludeComplianceDetails, ExcludeCompliantResources = ExcludeCompliantResources, ResourceARNList = ResourceARNList)
  output <- .resourcegroupstaggingapi$get_resources_output()
  config <- get_config()
  svc <- .resourcegroupstaggingapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$get_resources <- resourcegroupstaggingapi_get_resources

#' Returns all tag keys currently in use in the specified Amazon Web
#' Services Region for the calling account
#'
#' @description
#' Returns all tag keys currently in use in the specified Amazon Web Services Region for the calling account.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_get_tag_keys/](https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_get_tag_keys/) for full documentation.
#'
#' @param PaginationToken Specifies a `PaginationToken` response value from a previous request to
#' indicate that you want the next page of results. Leave this parameter
#' empty in your initial request.
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_get_tag_keys
resourcegroupstaggingapi_get_tag_keys <- function(PaginationToken = NULL) {
  op <- new_operation(
    name = "GetTagKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PaginationToken", output_token = "PaginationToken", result_key = "TagKeys")
  )
  input <- .resourcegroupstaggingapi$get_tag_keys_input(PaginationToken = PaginationToken)
  output <- .resourcegroupstaggingapi$get_tag_keys_output()
  config <- get_config()
  svc <- .resourcegroupstaggingapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$get_tag_keys <- resourcegroupstaggingapi_get_tag_keys

#' Returns all tag values for the specified key that are used in the
#' specified Amazon Web Services Region for the calling account
#'
#' @description
#' Returns all tag values for the specified key that are used in the specified Amazon Web Services Region for the calling account.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_get_tag_values/](https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_get_tag_values/) for full documentation.
#'
#' @param PaginationToken Specifies a `PaginationToken` response value from a previous request to
#' indicate that you want the next page of results. Leave this parameter
#' empty in your initial request.
#' @param Key &#91;required&#93; Specifies the tag key for which you want to list all existing values
#' that are currently used in the specified Amazon Web Services Region for
#' the calling account.
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_get_tag_values
resourcegroupstaggingapi_get_tag_values <- function(PaginationToken = NULL, Key) {
  op <- new_operation(
    name = "GetTagValues",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PaginationToken", output_token = "PaginationToken", result_key = "TagValues")
  )
  input <- .resourcegroupstaggingapi$get_tag_values_input(PaginationToken = PaginationToken, Key = Key)
  output <- .resourcegroupstaggingapi$get_tag_values_output()
  config <- get_config()
  svc <- .resourcegroupstaggingapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$get_tag_values <- resourcegroupstaggingapi_get_tag_values

#' Generates a report that lists all tagged resources in the accounts
#' across your organization and tells whether each resource is compliant
#' with the effective tag policy
#'
#' @description
#' Generates a report that lists all tagged resources in the accounts across your organization and tells whether each resource is compliant with the effective tag policy. Compliance data is refreshed daily. The report is generated asynchronously.
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_start_report_creation/](https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_start_report_creation/) for full documentation.
#'
#' @param S3Bucket &#91;required&#93; The name of the Amazon S3 bucket where the report will be stored; for
#' example:
#' 
#' `awsexamplebucket`
#' 
#' For more information on S3 bucket requirements, including an example
#' bucket policy, see the example S3 bucket policy on this page.
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_start_report_creation
resourcegroupstaggingapi_start_report_creation <- function(S3Bucket) {
  op <- new_operation(
    name = "StartReportCreation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .resourcegroupstaggingapi$start_report_creation_input(S3Bucket = S3Bucket)
  output <- .resourcegroupstaggingapi$start_report_creation_output()
  config <- get_config()
  svc <- .resourcegroupstaggingapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$start_report_creation <- resourcegroupstaggingapi_start_report_creation

#' Applies one or more tags to the specified resources
#'
#' @description
#' Applies one or more tags to the specified resources. Note the following:
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_tag_resources/](https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_tag_resources/) for full documentation.
#'
#' @param ResourceARNList &#91;required&#93; Specifies the list of ARNs of the resources that you want to apply tags
#' to.
#' 
#' An ARN (Amazon Resource Name) uniquely identifies a resource. For more
#' information, see [Amazon Resource Names (ARNs) and Amazon Web Services
#' Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param Tags &#91;required&#93; Specifies a list of tags that you want to add to the specified
#' resources. A tag consists of a key and a value that you define.
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_tag_resources
resourcegroupstaggingapi_tag_resources <- function(ResourceARNList, Tags) {
  op <- new_operation(
    name = "TagResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .resourcegroupstaggingapi$tag_resources_input(ResourceARNList = ResourceARNList, Tags = Tags)
  output <- .resourcegroupstaggingapi$tag_resources_output()
  config <- get_config()
  svc <- .resourcegroupstaggingapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$tag_resources <- resourcegroupstaggingapi_tag_resources

#' Removes the specified tags from the specified resources
#'
#' @description
#' Removes the specified tags from the specified resources. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from a resource that were already removed. Note the following:
#'
#' See [https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_untag_resources/](https://www.paws-r-sdk.com/docs/resourcegroupstaggingapi_untag_resources/) for full documentation.
#'
#' @param ResourceARNList &#91;required&#93; Specifies a list of ARNs of the resources that you want to remove tags
#' from.
#' 
#' An ARN (Amazon Resource Name) uniquely identifies a resource. For more
#' information, see [Amazon Resource Names (ARNs) and Amazon Web Services
#' Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param TagKeys &#91;required&#93; Specifies a list of tag keys that you want to remove from the specified
#' resources.
#'
#' @keywords internal
#'
#' @rdname resourcegroupstaggingapi_untag_resources
resourcegroupstaggingapi_untag_resources <- function(ResourceARNList, TagKeys) {
  op <- new_operation(
    name = "UntagResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .resourcegroupstaggingapi$untag_resources_input(ResourceARNList = ResourceARNList, TagKeys = TagKeys)
  output <- .resourcegroupstaggingapi$untag_resources_output()
  config <- get_config()
  svc <- .resourcegroupstaggingapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroupstaggingapi$operations$untag_resources <- resourcegroupstaggingapi_untag_resources
