% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_put_conformance_pack}
\alias{configservice_put_conformance_pack}
\title{Creates or updates a conformance pack}
\usage{
configservice_put_conformance_pack(
  ConformancePackName,
  TemplateS3Uri = NULL,
  TemplateBody = NULL,
  DeliveryS3Bucket = NULL,
  DeliveryS3KeyPrefix = NULL,
  ConformancePackInputParameters = NULL
)
}
\arguments{
\item{ConformancePackName}{[required] Name of the conformance pack you want to create.}

\item{TemplateS3Uri}{Location of file containing the template body
(\verb{s3://bucketname/prefix}). The uri must point to the conformance pack
template (max size: 300 KB) that is located in an Amazon S3 bucket in
the same region as the conformance pack.

You must have access to read Amazon S3 bucket.}

\item{TemplateBody}{A string containing full conformance pack template body. Structure
containing the template body with a minimum length of 1 byte and a
maximum length of 51,200 bytes.

You can only use a YAML template with two resource types: Config rule
(\verb{AWS::Config::ConfigRule}) and a remediation action
(\verb{AWS::Config::RemediationConfiguration}).}

\item{DeliveryS3Bucket}{The name of the Amazon S3 bucket where Config stores conformance pack
templates.

This field is optional.}

\item{DeliveryS3KeyPrefix}{The prefix for the Amazon S3 bucket.

This field is optional.}

\item{ConformancePackInputParameters}{A list of \code{ConformancePackInputParameter} objects.}
}
\description{
Creates or updates a conformance pack. A conformance pack is a collection of Config rules that can be easily deployed in an account and a region and across Amazon Web Services Organization. For information on how many conformance packs you can have per account, see \href{https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html}{\strong{Service Limits}} in the Config Developer Guide.

See \url{https://paws-r.github.io/docs/configservice/put_conformance_pack.html} for full documentation.
}
\keyword{internal}
