# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include applicationcostprofiler_service.R
NULL

#' Deletes the specified report definition in AWS Application Cost Profiler
#'
#' @description
#' Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being generated.
#'
#' See [https://paws-r.github.io/docs/applicationcostprofiler/delete_report_definition.html](https://paws-r.github.io/docs/applicationcostprofiler/delete_report_definition.html) for full documentation.
#'
#' @param reportId &#91;required&#93; Required. ID of the report to delete.
#'
#' @keywords internal
#'
#' @rdname applicationcostprofiler_delete_report_definition
applicationcostprofiler_delete_report_definition <- function(reportId) {
  op <- new_operation(
    name = "DeleteReportDefinition",
    http_method = "DELETE",
    http_path = "/reportDefinition/{reportId}",
    paginator = list()
  )
  input <- .applicationcostprofiler$delete_report_definition_input(reportId = reportId)
  output <- .applicationcostprofiler$delete_report_definition_output()
  config <- get_config()
  svc <- .applicationcostprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationcostprofiler$operations$delete_report_definition <- applicationcostprofiler_delete_report_definition

#' Retrieves the definition of a report already configured in AWS
#' Application Cost Profiler
#'
#' @description
#' Retrieves the definition of a report already configured in AWS Application Cost Profiler.
#'
#' See [https://paws-r.github.io/docs/applicationcostprofiler/get_report_definition.html](https://paws-r.github.io/docs/applicationcostprofiler/get_report_definition.html) for full documentation.
#'
#' @param reportId &#91;required&#93; ID of the report to retrieve.
#'
#' @keywords internal
#'
#' @rdname applicationcostprofiler_get_report_definition
applicationcostprofiler_get_report_definition <- function(reportId) {
  op <- new_operation(
    name = "GetReportDefinition",
    http_method = "GET",
    http_path = "/reportDefinition/{reportId}",
    paginator = list()
  )
  input <- .applicationcostprofiler$get_report_definition_input(reportId = reportId)
  output <- .applicationcostprofiler$get_report_definition_output()
  config <- get_config()
  svc <- .applicationcostprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationcostprofiler$operations$get_report_definition <- applicationcostprofiler_get_report_definition

#' Ingests application usage data from Amazon Simple Storage Service
#' (Amazon S3)
#'
#' @description
#' Ingests application usage data from Amazon Simple Storage Service (Amazon S3).
#'
#' See [https://paws-r.github.io/docs/applicationcostprofiler/import_application_usage.html](https://paws-r.github.io/docs/applicationcostprofiler/import_application_usage.html) for full documentation.
#'
#' @param sourceS3Location &#91;required&#93; Amazon S3 location to import application usage data from.
#'
#' @keywords internal
#'
#' @rdname applicationcostprofiler_import_application_usage
applicationcostprofiler_import_application_usage <- function(sourceS3Location) {
  op <- new_operation(
    name = "ImportApplicationUsage",
    http_method = "POST",
    http_path = "/importApplicationUsage",
    paginator = list()
  )
  input <- .applicationcostprofiler$import_application_usage_input(sourceS3Location = sourceS3Location)
  output <- .applicationcostprofiler$import_application_usage_output()
  config <- get_config()
  svc <- .applicationcostprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationcostprofiler$operations$import_application_usage <- applicationcostprofiler_import_application_usage

#' Retrieves a list of all reports and their configurations for your AWS
#' account
#'
#' @description
#' Retrieves a list of all reports and their configurations for your AWS account.
#'
#' See [https://paws-r.github.io/docs/applicationcostprofiler/list_report_definitions.html](https://paws-r.github.io/docs/applicationcostprofiler/list_report_definitions.html) for full documentation.
#'
#' @param nextToken The token value from a previous call to access the next page of results.
#' @param maxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname applicationcostprofiler_list_report_definitions
applicationcostprofiler_list_report_definitions <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListReportDefinitions",
    http_method = "GET",
    http_path = "/reportDefinition",
    paginator = list()
  )
  input <- .applicationcostprofiler$list_report_definitions_input(nextToken = nextToken, maxResults = maxResults)
  output <- .applicationcostprofiler$list_report_definitions_output()
  config <- get_config()
  svc <- .applicationcostprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationcostprofiler$operations$list_report_definitions <- applicationcostprofiler_list_report_definitions

#' Creates the report definition for a report in Application Cost Profiler
#'
#' @description
#' Creates the report definition for a report in Application Cost Profiler.
#'
#' See [https://paws-r.github.io/docs/applicationcostprofiler/put_report_definition.html](https://paws-r.github.io/docs/applicationcostprofiler/put_report_definition.html) for full documentation.
#'
#' @param reportId &#91;required&#93; Required. ID of the report. You can choose any valid string matching the
#' pattern for the ID.
#' @param reportDescription &#91;required&#93; Required. Description of the report.
#' @param reportFrequency &#91;required&#93; Required. The cadence to generate the report.
#' @param format &#91;required&#93; Required. The format to use for the generated report.
#' @param destinationS3Location &#91;required&#93; Required. Amazon Simple Storage Service (Amazon S3) location where
#' Application Cost Profiler uploads the report.
#'
#' @keywords internal
#'
#' @rdname applicationcostprofiler_put_report_definition
applicationcostprofiler_put_report_definition <- function(reportId, reportDescription, reportFrequency, format, destinationS3Location) {
  op <- new_operation(
    name = "PutReportDefinition",
    http_method = "POST",
    http_path = "/reportDefinition",
    paginator = list()
  )
  input <- .applicationcostprofiler$put_report_definition_input(reportId = reportId, reportDescription = reportDescription, reportFrequency = reportFrequency, format = format, destinationS3Location = destinationS3Location)
  output <- .applicationcostprofiler$put_report_definition_output()
  config <- get_config()
  svc <- .applicationcostprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationcostprofiler$operations$put_report_definition <- applicationcostprofiler_put_report_definition

#' Updates existing report in AWS Application Cost Profiler
#'
#' @description
#' Updates existing report in AWS Application Cost Profiler.
#'
#' See [https://paws-r.github.io/docs/applicationcostprofiler/update_report_definition.html](https://paws-r.github.io/docs/applicationcostprofiler/update_report_definition.html) for full documentation.
#'
#' @param reportId &#91;required&#93; Required. ID of the report to update.
#' @param reportDescription &#91;required&#93; Required. Description of the report.
#' @param reportFrequency &#91;required&#93; Required. The cadence to generate the report.
#' @param format &#91;required&#93; Required. The format to use for the generated report.
#' @param destinationS3Location &#91;required&#93; Required. Amazon Simple Storage Service (Amazon S3) location where
#' Application Cost Profiler uploads the report.
#'
#' @keywords internal
#'
#' @rdname applicationcostprofiler_update_report_definition
applicationcostprofiler_update_report_definition <- function(reportId, reportDescription, reportFrequency, format, destinationS3Location) {
  op <- new_operation(
    name = "UpdateReportDefinition",
    http_method = "PUT",
    http_path = "/reportDefinition/{reportId}",
    paginator = list()
  )
  input <- .applicationcostprofiler$update_report_definition_input(reportId = reportId, reportDescription = reportDescription, reportFrequency = reportFrequency, format = format, destinationS3Location = destinationS3Location)
  output <- .applicationcostprofiler$update_report_definition_output()
  config <- get_config()
  svc <- .applicationcostprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationcostprofiler$operations$update_report_definition <- applicationcostprofiler_update_report_definition
