% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/managedgrafana_operations.R
\name{managedgrafana_update_workspace}
\alias{managedgrafana_update_workspace}
\title{Modifies an existing Amazon Managed Grafana workspace}
\usage{
managedgrafana_update_workspace(
  accountAccessType = NULL,
  organizationRoleName = NULL,
  permissionType = NULL,
  stackSetName = NULL,
  workspaceDataSources = NULL,
  workspaceDescription = NULL,
  workspaceId,
  workspaceName = NULL,
  workspaceNotificationDestinations = NULL,
  workspaceOrganizationalUnits = NULL,
  workspaceRoleArn = NULL
)
}
\arguments{
\item{accountAccessType}{Specifies whether the workspace can access Amazon Web Services resources
in this Amazon Web Services account only, or whether it can also access
Amazon Web Services resources in other accounts in the same
organization. If you specify \code{ORGANIZATION}, you must specify which
organizational units the workspace can access in the
\code{workspaceOrganizationalUnits} parameter.}

\item{organizationRoleName}{The name of an IAM role that already exists to use to access resources
through Organizations.}

\item{permissionType}{If you specify \verb{Service Managed}, Amazon Managed Grafana automatically
creates the IAM roles and provisions the permissions that the workspace
needs to use Amazon Web Services data sources and notification channels.

If you specify \code{CUSTOMER_MANAGED}, you will manage those roles and
permissions yourself. If you are creating this workspace in a member
account of an organization and that account is not a delegated
administrator account, and you want the workspace to access data sources
in other Amazon Web Services accounts in the organization, you must
choose \code{CUSTOMER_MANAGED}.

For more information, see \href{https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html}{Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels}}

\item{stackSetName}{The name of the CloudFormation stack set to use to generate IAM roles to
be used for this workspace.}

\item{workspaceDataSources}{Specify the Amazon Web Services data sources that you want to be queried
in this workspace. Specifying these data sources here enables Amazon
Managed Grafana to create IAM roles and permissions that allow Amazon
Managed Grafana to read data from these sources. You must still add them
as data sources in the Grafana console in the workspace.

If you don't specify a data source here, you can still add it as a data
source later in the workspace console. However, you will then have to
manually configure permissions for it.}

\item{workspaceDescription}{A description for the workspace. This is used only to help you identify
this workspace.}

\item{workspaceId}{[required] The ID of the workspace to update.}

\item{workspaceName}{A new name for the workspace to update.}

\item{workspaceNotificationDestinations}{Specify the Amazon Web Services notification channels that you plan to
use in this workspace. Specifying these data sources here enables Amazon
Managed Grafana to create IAM roles and permissions that allow Amazon
Managed Grafana to use these channels.}

\item{workspaceOrganizationalUnits}{Specifies the organizational units that this workspace is allowed to use
data sources from, if this workspace is in an account that is part of an
organization.}

\item{workspaceRoleArn}{The workspace needs an IAM role that grants permissions to the Amazon
Web Services resources that the workspace will view data from. If you
already have a role that you want to use, specify it here. If you omit
this field and you specify some Amazon Web Services resources in
\code{workspaceDataSources} or \code{workspaceNotificationDestinations}, a new IAM
role with the necessary permissions is automatically created.}
}
\description{
Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.

See \url{https://paws-r.github.io/docs/managedgrafana/update_workspace.html} for full documentation.
}
\keyword{internal}
