% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_resource_config_history}
\alias{configservice_get_resource_config_history}
\title{Returns a list of ConfigurationItems for the specified resource}
\usage{
configservice_get_resource_config_history(
  resourceType,
  resourceId,
  laterTime = NULL,
  earlierTime = NULL,
  chronologicalOrder = NULL,
  limit = NULL,
  nextToken = NULL
)
}
\arguments{
\item{resourceType}{[required] The resource type.}

\item{resourceId}{[required] The ID of the resource (for example., \code{sg-xxxxxx}).}

\item{laterTime}{The time stamp that indicates a later time. If not specified, current
time is taken.}

\item{earlierTime}{The time stamp that indicates an earlier time. If not specified, the
action returns paginated results that contain configuration items that
start when the first configuration item was recorded.}

\item{chronologicalOrder}{The chronological order for configuration items listed. By default, the
results are listed in reverse chronological order.}

\item{limit}{The maximum number of configuration items returned on each page. The
default is 10. You cannot specify a number greater than 100. If you
specify 0, Config uses the default.}

\item{nextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Returns a list of \code{ConfigurationItems} for the specified resource. The list contains details about each state of the resource during the specified time interval. If you specified a retention period to retain your \code{ConfigurationItems} between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns the \code{ConfigurationItems} for the specified retention period.

See \url{https://paws-r.github.io/docs/configservice/get_resource_config_history.html} for full documentation.
}
\keyword{internal}
