% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_get_metric_statistics}
\alias{cloudwatch_get_metric_statistics}
\title{Gets statistics for the specified metric}
\usage{
cloudwatch_get_metric_statistics(
  Namespace,
  MetricName,
  Dimensions = NULL,
  StartTime,
  EndTime,
  Period,
  Statistics = NULL,
  ExtendedStatistics = NULL,
  Unit = NULL
)
}
\arguments{
\item{Namespace}{[required] The namespace of the metric, with or without spaces.}

\item{MetricName}{[required] The name of the metric, with or without spaces.}

\item{Dimensions}{The dimensions. If the metric contains multiple dimensions, you must
include a value for each dimension. CloudWatch treats each unique
combination of dimensions as a separate metric. If a specific
combination of dimensions was not published, you can't retrieve
statistics for it. You must specify the same dimensions that were used
when the metrics were created. For an example, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations}{Dimension Combinations}
in the \emph{Amazon CloudWatch User Guide}. For more information about
specifying dimensions, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html}{Publishing Metrics}
in the \emph{Amazon CloudWatch User Guide}.}

\item{StartTime}{[required] The time stamp that determines the first data point to return. Start
times are evaluated relative to the time that CloudWatch receives the
request.

The value specified is inclusive; results include data points with the
specified time stamp. In a raw HTTP query, the time stamp must be in ISO
8601 UTC format (for example, 2016-10-03T23:00:00Z).

CloudWatch rounds the specified time stamp as follows:
\itemize{
\item Start time less than 15 days ago - Round down to the nearest whole
minute. For example, 12:32:34 is rounded down to 12:32:00.
\item Start time between 15 and 63 days ago - Round down to the nearest
5-minute clock interval. For example, 12:32:34 is rounded down to
12:30:00.
\item Start time greater than 63 days ago - Round down to the nearest
1-hour clock interval. For example, 12:32:34 is rounded down to
12:00:00.
}

If you set \code{Period} to 5, 10, or 30, the start time of your request is
rounded down to the nearest time that corresponds to even 5-, 10-, or
30-second divisions of a minute. For example, if you make a query at
(HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of
your request is rounded down and you receive data from 01:05:10 to
01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of
data, using a period of 5 seconds, you receive data timestamped between
15:02:15 and 15:07:15.}

\item{EndTime}{[required] The time stamp that determines the last data point to return.

The value specified is exclusive; results include data points up to the
specified time stamp. In a raw HTTP query, the time stamp must be in ISO
8601 UTC format (for example, 2016-10-10T23:00:00Z).}

\item{Period}{[required] The granularity, in seconds, of the returned data points. For metrics
with regular resolution, a period can be as short as one minute (60
seconds) and must be a multiple of 60. For high-resolution metrics that
are collected at intervals of less than one minute, the period can be 1,
5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those
metrics stored by a \code{\link[=cloudwatch_put_metric_data]{put_metric_data}} call
that includes a \code{StorageResolution} of 1 second.

If the \code{StartTime} parameter specifies a time stamp that is greater than
3 hours ago, you must specify the period as follows or no data points in
that time range is returned:
\itemize{
\item Start time between 3 hours and 15 days ago - Use a multiple of 60
seconds (1 minute).
\item Start time between 15 and 63 days ago - Use a multiple of 300
seconds (5 minutes).
\item Start time greater than 63 days ago - Use a multiple of 3600 seconds
(1 hour).
}}

\item{Statistics}{The metric statistics, other than percentile. For percentile statistics,
use \code{ExtendedStatistics}. When calling
\code{\link[=cloudwatch_get_metric_statistics]{get_metric_statistics}}, you must
specify either \code{Statistics} or \code{ExtendedStatistics}, but not both.}

\item{ExtendedStatistics}{The percentile statistics. Specify values between p0.0 and p100. When
calling \code{\link[=cloudwatch_get_metric_statistics]{get_metric_statistics}}, you
must specify either \code{Statistics} or \code{ExtendedStatistics}, but not both.
Percentile statistics are not available for metrics when any of the
metric values are negative numbers.}

\item{Unit}{The unit for a given metric. If you omit \code{Unit}, all data that was
collected with any unit is returned, along with the corresponding units
that were specified when the data was reported to CloudWatch. If you
specify a unit, the operation returns only data that was collected with
that unit specified. If you specify a unit that does not match the data
collected, the results of the operation are null. CloudWatch does not
perform unit conversions.}
}
\description{
Gets statistics for the specified metric.

See \url{https://paws-r.github.io/docs/cloudwatch/get_metric_statistics.html} for full documentation.
}
\keyword{internal}
