% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_describe_account}
\alias{organizations_describe_account}
\title{Retrieves AWS Organizations related information about the specified
account}
\usage{
organizations_describe_account(AccountId)
}
\arguments{
\item{AccountId}{[required] The unique identifier (ID) of the AWS account that you want information
about. You can get the ID from the ListAccounts or ListAccountsForParent
operations.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for an account ID
string requires exactly 12 digits.}
}
\description{
Retrieves AWS Organizations related information about the specified
account.
}
\details{
This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$describe_account(
  AccountId = "string"
)
}
}

\examples{
# The following example shows a user in the master account (111111111111)
# asking for details about account 555555555555:
\dontrun{svc$describe_account(
  AccountId = "555555555555"
)}

}
\keyword{internal}
