% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_set_permission}
\alias{opsworks_set_permission}
\title{Specifies a user's permissions}
\usage{
opsworks_set_permission(StackId, IamUserArn, AllowSsh, AllowSudo, Level)
}
\arguments{
\item{StackId}{[required] The stack ID.}

\item{IamUserArn}{[required] The user\'s IAM ARN. This can also be a federated user\'s ARN.}

\item{AllowSsh}{The user is allowed to use SSH to communicate with the instance.}

\item{AllowSudo}{The user is allowed to use \strong{sudo} to elevate privileges.}

\item{Level}{The user\'s permission level, which must be set to one of the following
strings. You cannot set your own permissions level.
\itemize{
\item \code{deny}
\item \code{show}
\item \code{deploy}
\item \code{manage}
\item \code{iam_only}
}

For more information about the permissions associated with these levels,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.}
}
\description{
Specifies a user\'s permissions. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingsecurity.html}{Security and Permissions}.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$set_permission(
  StackId = "string",
  IamUserArn = "string",
  AllowSsh = TRUE|FALSE,
  AllowSudo = TRUE|FALSE,
  Level = "string"
)
}
}

\keyword{internal}
