# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Auto Scaling Plans
#'
#' @description
#' AWS Auto Scaling
#' 
#' Use AWS Auto Scaling to quickly discover all the scalable AWS resources
#' for your application and configure dynamic scaling and predictive
#' scaling for your resources using scaling plans. Use this service in
#' conjunction with the Amazon EC2 Auto Scaling, Application Auto Scaling,
#' Amazon CloudWatch, and AWS CloudFormation services.
#' 
#' Currently, predictive scaling is only available for Amazon EC2 Auto
#' Scaling groups.
#' 
#' For more information about AWS Auto Scaling, including information about
#' granting IAM users required permissions for AWS Auto Scaling actions,
#' see the [AWS Auto Scaling User
#' Guide](https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-aws-auto-scaling.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- autoscalingplans(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- autoscalingplans()
#' svc$create_scaling_plan(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=autoscalingplans_create_scaling_plan]{create_scaling_plan} \tab Creates a scaling plan \cr
#'  \link[=autoscalingplans_delete_scaling_plan]{delete_scaling_plan} \tab Deletes the specified scaling plan \cr
#'  \link[=autoscalingplans_describe_scaling_plan_resources]{describe_scaling_plan_resources} \tab Describes the scalable resources in the specified scaling plan\cr
#'  \link[=autoscalingplans_describe_scaling_plans]{describe_scaling_plans} \tab Describes one or more of your scaling plans \cr
#'  \link[=autoscalingplans_get_scaling_plan_resource_forecast_data]{get_scaling_plan_resource_forecast_data} \tab Retrieves the forecast data for a scalable resource \cr
#'  \link[=autoscalingplans_update_scaling_plan]{update_scaling_plan} \tab Updates the specified scaling plan 
#' }
#'
#' @rdname autoscalingplans
#' @export
autoscalingplans <- function(config = list()) {
  svc <- .autoscalingplans$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.autoscalingplans <- list()

.autoscalingplans$operations <- list()

.autoscalingplans$metadata <- list(
  service_name = "autoscaling",
  endpoints = list("*" = list(endpoint = "autoscaling.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "autoscaling.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Auto Scaling Plans",
  api_version = "2018-01-06",
  signing_name = "autoscaling-plans",
  json_version = "1.1",
  target_prefix = "AnyScaleScalingPlannerFrontendService"
)

.autoscalingplans$handlers <- new_handlers("jsonrpc", "v4")

.autoscalingplans$service <- function(config = list()) {
  new_service(.autoscalingplans$metadata, .autoscalingplans$handlers, config)
}
