% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_stacks}
\alias{opsworks_describe_stacks}
\title{Requests a description of one or more stacks}
\usage{
opsworks_describe_stacks(StackIds)
}
\arguments{
\item{StackIds}{An array of stack IDs that specify the stacks to be described. If you
omit this parameter, \code{\link[=opsworks_describe_stacks]{describe_stacks}}
returns a description of every stack.}
}
\value{
A list with the following syntax:\preformatted{list(
  Stacks = list(
    list(
      StackId = "string",
      Name = "string",
      Arn = "string",
      Region = "string",
      VpcId = "string",
      Attributes = list(
        "string"
      ),
      ServiceRoleArn = "string",
      DefaultInstanceProfileArn = "string",
      DefaultOs = "string",
      HostnameTheme = "string",
      DefaultAvailabilityZone = "string",
      DefaultSubnetId = "string",
      CustomJson = "string",
      ConfigurationManager = list(
        Name = "string",
        Version = "string"
      ),
      ChefConfiguration = list(
        ManageBerkshelf = TRUE|FALSE,
        BerkshelfVersion = "string"
      ),
      UseCustomCookbooks = TRUE|FALSE,
      UseOpsworksSecurityGroups = TRUE|FALSE,
      CustomCookbooksSource = list(
        Type = "git"|"svn"|"archive"|"s3",
        Url = "string",
        Username = "string",
        Password = "string",
        SshKey = "string",
        Revision = "string"
      ),
      DefaultSshKeyName = "string",
      CreatedAt = "string",
      DefaultRootDeviceType = "ebs"|"instance-store",
      AgentVersion = "string"
    )
  )
)
}
}
\description{
Requests a description of one or more stacks.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_stacks(
  StackIds = list(
    "string"
  )
)
}
}

\keyword{internal}
