% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_delete_remediation_exceptions}
\alias{configservice_delete_remediation_exceptions}
\title{Deletes one or more remediation exceptions mentioned in the resource
keys}
\usage{
configservice_delete_remediation_exceptions(ConfigRuleName,
  ResourceKeys)
}
\arguments{
\item{ConfigRuleName}{[required] The name of the AWS Config rule for which you want to delete remediation
exception configuration.}

\item{ResourceKeys}{[required] An exception list of resource exception keys to be processed with the
current request. AWS Config adds exception for each resource key. For
example, AWS Config adds 3 exceptions for 3 resource keys.}
}
\value{
A list with the following syntax:\preformatted{list(
  FailedBatches = list(
    list(
      FailureMessage = "string",
      FailedItems = list(
        list(
          ResourceType = "string",
          ResourceId = "string"
        )
      )
    )
  )
)
}
}
\description{
Deletes one or more remediation exceptions mentioned in the resource
keys.

AWS Config generates a remediation exception when a problem occurs
executing a remediation action to a specific resource. Remediation
exceptions blocks auto-remediation until the exception is cleared.
}
\section{Request syntax}{
\preformatted{svc$delete_remediation_exceptions(
  ConfigRuleName = "string",
  ResourceKeys = list(
    list(
      ResourceType = "string",
      ResourceId = "string"
    )
  )
)
}
}

\keyword{internal}
