% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_maintenance_window_task}
\alias{ssm_update_maintenance_window_task}
\title{Modifies a task assigned to a Maintenance Window}
\usage{
ssm_update_maintenance_window_task(WindowId, WindowTaskId, Targets,
  TaskArn, ServiceRoleArn, TaskParameters, TaskInvocationParameters,
  Priority, MaxConcurrency, MaxErrors, LoggingInfo, Name, Description,
  Replace)
}
\arguments{
\item{WindowId}{[required] The Maintenance Window ID that contains the task to modify.}

\item{WindowTaskId}{[required] The task ID to modify.}

\item{Targets}{The targets (either instances or tags) to modify. Instances are
specified using Key=instanceids,Values=instanceID\_1,instanceID\_2. Tags
are specified using Key=tag\_name,Values=tag\_value.}

\item{TaskArn}{The task ARN to modify.}

\item{ServiceRoleArn}{The IAM service role ARN to modify. The system assumes this role during
task execution.

If you do not specify a service role ARN, Systems Manager will use your
account's service-linked role for Systems Manager by default. If no
service-linked role for Systems Manager exists in your account, it will
be created when you run \code{RegisterTaskWithMaintenanceWindow} without
specifying a service role ARN.

For more information, see \href{http://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions}{Service-Linked Role Permissions for Systems Manager}
and \href{http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role}{Should I Use a Service-Linked Role or a Custom Service Role to Run Maintenance Window Tasks?}
in the \emph{AWS Systems Manager User Guide}.}

\item{TaskParameters}{The parameters to modify.

\code{TaskParameters} has been deprecated. To specify parameters to pass to a
task when it runs, instead use the \code{Parameters} option in the
\code{TaskInvocationParameters} structure. For information about how Systems
Manager handles these options for the supported Maintenance Window task
types, see MaintenanceWindowTaskInvocationParameters.

The map has the following format:

Key: string, between 1 and 255 characters

Value: an array of strings, each string is between 1 and 255 characters}

\item{TaskInvocationParameters}{The parameters that the task should use during execution. Populate only
the fields that match the task type. All other fields should be empty.}

\item{Priority}{The new task priority to specify. The lower the number, the higher the
priority. Tasks that have the same priority are scheduled in parallel.}

\item{MaxConcurrency}{The new \code{MaxConcurrency} value you want to specify. \code{MaxConcurrency} is
the number of targets that are allowed to run this task in parallel.}

\item{MaxErrors}{The new \code{MaxErrors} value to specify. \code{MaxErrors} is the maximum number
of errors that are allowed before the task stops being scheduled.}

\item{LoggingInfo}{The new logging location in Amazon S3 to specify.

\code{LoggingInfo} has been deprecated. To specify an S3 bucket to contain
logs, instead use the \code{OutputS3BucketName} and \code{OutputS3KeyPrefix}
options in the \code{TaskInvocationParameters} structure. For information
about how Systems Manager handles these options for the supported
Maintenance Window task types, see
MaintenanceWindowTaskInvocationParameters.}

\item{Name}{The new task name to specify.}

\item{Description}{The new task description to specify.}

\item{Replace}{If True, then all fields that are required by the
RegisterTaskWithMaintenanceWndow action are also required for this API
request. Optional fields that are not specified are set to null.}
}
\description{
Modifies a task assigned to a Maintenance Window. You can't change the
task type, but you can change the following values:
}
\details{
\itemize{
\item TaskARN. For example, you can change a RUN\_COMMAND task from
AWS-RunPowerShellScript to AWS-RunShellScript.
\item ServiceRoleArn
\item TaskInvocationParameters
\item Priority
\item MaxConcurrency
\item MaxErrors
}

If a parameter is null, then the corresponding field is not modified.
Also, if you set Replace to true, then all fields required by the
RegisterTaskWithMaintenanceWindow action are required for this request.
Optional fields that aren't specified are set to null.
}
\section{Request syntax}{
\preformatted{svc$update_maintenance_window_task(
  WindowId = "string",
  WindowTaskId = "string",
  Targets = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  TaskArn = "string",
  ServiceRoleArn = "string",
  TaskParameters = list(
    list(
      Values = list(
        "string"
      )
    )
  ),
  TaskInvocationParameters = list(
    RunCommand = list(
      Comment = "string",
      DocumentHash = "string",
      DocumentHashType = "Sha256"|"Sha1",
      NotificationConfig = list(
        NotificationArn = "string",
        NotificationEvents = list(
          "All"|"InProgress"|"Success"|"TimedOut"|"Cancelled"|"Failed"
        ),
        NotificationType = "Command"|"Invocation"
      ),
      OutputS3BucketName = "string",
      OutputS3KeyPrefix = "string",
      Parameters = list(
        list(
          "string"
        )
      ),
      ServiceRoleArn = "string",
      TimeoutSeconds = 123
    ),
    Automation = list(
      DocumentVersion = "string",
      Parameters = list(
        list(
          "string"
        )
      )
    ),
    StepFunctions = list(
      Input = "string",
      Name = "string"
    ),
    Lambda = list(
      ClientContext = "string",
      Qualifier = "string",
      Payload = raw
    )
  ),
  Priority = 123,
  MaxConcurrency = "string",
  MaxErrors = "string",
  LoggingInfo = list(
    S3BucketName = "string",
    S3KeyPrefix = "string",
    S3Region = "string"
  ),
  Name = "string",
  Description = "string",
  Replace = TRUE|FALSE
)
}
}

\keyword{internal}
