% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_create_provisioning_artifact}
\alias{servicecatalog_create_provisioning_artifact}
\title{Creates a provisioning artifact (also known as a version) for the
specified product}
\usage{
servicecatalog_create_provisioning_artifact(AcceptLanguage, ProductId,
  Parameters, IdempotencyToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{[required] The product identifier.}

\item{Parameters}{[required] The configuration for the provisioning artifact.}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}
}
\description{
Creates a provisioning artifact (also known as a version) for the
specified product.
}
\details{
You cannot create a provisioning artifact for a product that was shared
with you.
}
\section{Request syntax}{
\preformatted{svc$create_provisioning_artifact(
  AcceptLanguage = "string",
  ProductId = "string",
  Parameters = list(
    Name = "string",
    Description = "string",
    Info = list(
      "string"
    ),
    Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE_AMI"|"MARKETPLACE_CAR"
  ),
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
