% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_update_organizational_unit}
\alias{organizations_update_organizational_unit}
\title{Renames the specified organizational unit (OU)}
\usage{
organizations_update_organizational_unit(OrganizationalUnitId, Name)
}
\arguments{
\item{OrganizationalUnitId}{[required] The unique identifier (ID) of the OU that you want to rename. You can
get the ID from the ListOrganizationalUnitsForParent operation.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for an
organizational unit ID string requires "ou-" followed by from 4 to 32
lower-case letters or digits (the ID of the root that contains the OU)
followed by a second "-" dash and from 8 to 32 additional lower-case
letters or digits.}

\item{Name}{The new name that you want to assign to the OU.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} that is used to
validate this parameter is a string of any of the characters in the
ASCII character range.}
}
\description{
Renames the specified organizational unit (OU). The ID and ARN do not
change. The child OUs and accounts remain in place, and any attached
policies of the OU remain attached.
}
\details{
This operation can be called only from the organization's master
account.
}
\section{Request syntax}{
\preformatted{svc$update_organizational_unit(
  OrganizationalUnitId = "string",
  Name = "string"
)
}
}

\examples{
# The following example shows how to rename an OU. The output confirms the
# new name:/n/n
\donttest{svc$update_organizational_unit(
  Name = "AccountingOU",
  OrganizationalUnitId = "ou-examplerootid111-exampleouid111"
)}

}
\keyword{internal}
