% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_get_event_prediction}
\alias{frauddetector_get_event_prediction}
\title{Evaluates an event against a detector version}
\usage{
frauddetector_get_event_prediction(
  detectorId,
  detectorVersionId = NULL,
  eventId,
  eventTypeName,
  entities,
  eventTimestamp,
  eventVariables,
  externalModelEndpointDataBlobs = NULL
)
}
\arguments{
\item{detectorId}{[required] The detector ID.}

\item{detectorVersionId}{The detector version ID.}

\item{eventId}{[required] The unique ID used to identify the event.}

\item{eventTypeName}{[required] The event type associated with the detector specified for the
prediction.}

\item{entities}{[required] The entity type (associated with the detector's event type) and specific
entity ID representing who performed the event. If an entity id is not
available, use "UNKNOWN."}

\item{eventTimestamp}{[required] Timestamp that defines when the event under evaluation occurred. The
timestamp must be specified using ISO 8601 standard in UTC.}

\item{eventVariables}{[required] Names of the event type's variables you defined in Amazon Fraud Detector
to represent data elements and their corresponding values for the event
you are sending for evaluation.

You must provide at least one eventVariable

To ensure most accurate fraud prediction and to simplify your data
preparation, Amazon Fraud Detector will replace all missing variables or
values as follows:

\strong{For Amazon Fraud Detector trained models:}

If a null value is provided explicitly for a variable or if a variable
is missing, model will replace the null value or the missing variable
(no variable name in the eventVariables map) with calculated default
mean/medians for numeric variables and with special values for
categorical variables.

\strong{For imported SageMaker models:}

If a null value is provided explicitly for a variable, the model and
rules will use “null” as the value. If a variable is not provided (no
variable name in the eventVariables map), model and rules will use the
default value that is provided for the variable.}

\item{externalModelEndpointDataBlobs}{The Amazon SageMaker model endpoint input data blobs.}
}
\description{
Evaluates an event against a detector version. If a version ID is not provided, the detector’s (\code{ACTIVE}) version is used.

See \url{https://www.paws-r-sdk.com/docs/frauddetector_get_event_prediction/} for full documentation.
}
\keyword{internal}
