% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_tag_resource}
\alias{transcribeservice_tag_resource}
\title{Adds one or more custom tags, each in the form of a key:value pair, to
the specified resource}
\usage{
transcribeservice_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource you want to tag. ARNs
have the format
\code{arn:partition:service:region:account-id:resource-type/resource-id}.

For example,
\code{arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name}.

Valid values for \code{resource-type} are: \code{transcription-job},
\code{medical-transcription-job}, \code{vocabulary}, \code{medical-vocabulary},
\code{vocabulary-filter}, and \code{language-model}.}

\item{Tags}{[required] Adds one or more custom tags, each in the form of a key:value pair, to
the specified resource.

To learn more about using tags with Amazon Transcribe, refer to \href{https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html}{Tagging resources}.}
}
\description{
Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.

See \url{https://www.paws-r-sdk.com/docs/transcribeservice_tag_resource/} for full documentation.
}
\keyword{internal}
