% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_update_guardrail}
\alias{bedrock_update_guardrail}
\title{Updates a guardrail with the values you specify}
\usage{
bedrock_update_guardrail(
  guardrailIdentifier,
  name,
  description = NULL,
  topicPolicyConfig = NULL,
  contentPolicyConfig = NULL,
  wordPolicyConfig = NULL,
  sensitiveInformationPolicyConfig = NULL,
  blockedInputMessaging,
  blockedOutputsMessaging,
  kmsKeyId = NULL
)
}
\arguments{
\item{guardrailIdentifier}{[required] The unique identifier of the guardrail}

\item{name}{[required] A name for the guardrail.}

\item{description}{A description of the guardrail.}

\item{topicPolicyConfig}{The topic policy to configure for the guardrail.}

\item{contentPolicyConfig}{The content policy to configure for the guardrail.}

\item{wordPolicyConfig}{The word policy to configure for the guardrail.}

\item{sensitiveInformationPolicyConfig}{The sensitive information policy to configure for the guardrail.}

\item{blockedInputMessaging}{[required] The message to return when the guardrail blocks a prompt.}

\item{blockedOutputsMessaging}{[required] The message to return when the guardrail blocks a model response.}

\item{kmsKeyId}{The ARN of the KMS key with which to encrypt the guardrail.}
}
\description{
Updates a guardrail with the values you specify.

See \url{https://www.paws-r-sdk.com/docs/bedrock_update_guardrail/} for full documentation.
}
\keyword{internal}
