% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voiceid_operations.R
\name{voiceid_update_domain}
\alias{voiceid_update_domain}
\title{Updates the specified domain}
\usage{
voiceid_update_domain(
  Description = NULL,
  DomainId,
  Name,
  ServerSideEncryptionConfiguration
)
}
\arguments{
\item{Description}{A brief description about this domain.}

\item{DomainId}{[required] The identifier of the domain to be updated.}

\item{Name}{[required] The name of the domain.}

\item{ServerSideEncryptionConfiguration}{[required] The configuration, containing the KMS key identifier, to be used by
Voice ID for the server-side encryption of your data. Changing the
domain's associated KMS key immediately triggers an asynchronous process
to remove dependency on the old KMS key, such that the domain's data can
only be accessed using the new KMS key. The domain's
\code{ServerSideEncryptionUpdateDetails} contains the details for this
process.}
}
\description{
Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an optional field, such as 'Description' is not provided, it is removed from the domain.

See \url{https://www.paws-r-sdk.com/docs/voiceid_update_domain/} for full documentation.
}
\keyword{internal}
