# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include voiceid_service.R
NULL

#' Associates the fraudsters with the watchlist specified in the same
#' domain
#'
#' @description
#' Associates the fraudsters with the watchlist specified in the same domain.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_associate_fraudster/](https://www.paws-r-sdk.com/docs/voiceid_associate_fraudster/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the fraudster.
#' @param FraudsterId &#91;required&#93; The identifier of the fraudster to be associated with the watchlist.
#' @param WatchlistId &#91;required&#93; The identifier of the watchlist you want to associate with the
#' fraudster.
#'
#' @keywords internal
#'
#' @rdname voiceid_associate_fraudster
voiceid_associate_fraudster <- function(DomainId, FraudsterId, WatchlistId) {
  op <- new_operation(
    name = "AssociateFraudster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$associate_fraudster_input(DomainId = DomainId, FraudsterId = FraudsterId, WatchlistId = WatchlistId)
  output <- .voiceid$associate_fraudster_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$associate_fraudster <- voiceid_associate_fraudster

#' Creates a domain that contains all Amazon Connect Voice ID data, such as
#' speakers, fraudsters, customer audio, and voiceprints
#'
#' @description
#' Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints. Every domain is created with a default watchlist that fraudsters can be a part of.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_create_domain/](https://www.paws-r-sdk.com/docs/voiceid_create_domain/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param Description A brief description of this domain.
#' @param Name &#91;required&#93; The name of the domain.
#' @param ServerSideEncryptionConfiguration &#91;required&#93; The configuration, containing the KMS key identifier, to be used by
#' Voice ID for the server-side encryption of your data. Refer to [Amazon
#' Connect Voice ID encryption at
#' rest](https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid)
#' for more details on how the KMS key is used.
#' @param Tags A list of tags you want added to the domain.
#'
#' @keywords internal
#'
#' @rdname voiceid_create_domain
voiceid_create_domain <- function(ClientToken = NULL, Description = NULL, Name, ServerSideEncryptionConfiguration, Tags = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$create_domain_input(ClientToken = ClientToken, Description = Description, Name = Name, ServerSideEncryptionConfiguration = ServerSideEncryptionConfiguration, Tags = Tags)
  output <- .voiceid$create_domain_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$create_domain <- voiceid_create_domain

#' Creates a watchlist that fraudsters can be a part of
#'
#' @description
#' Creates a watchlist that fraudsters can be a part of.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_create_watchlist/](https://www.paws-r-sdk.com/docs/voiceid_create_watchlist/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param Description A brief description of this watchlist.
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the watchlist.
#' @param Name &#91;required&#93; The name of the watchlist.
#'
#' @keywords internal
#'
#' @rdname voiceid_create_watchlist
voiceid_create_watchlist <- function(ClientToken = NULL, Description = NULL, DomainId, Name) {
  op <- new_operation(
    name = "CreateWatchlist",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$create_watchlist_input(ClientToken = ClientToken, Description = Description, DomainId = DomainId, Name = Name)
  output <- .voiceid$create_watchlist_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$create_watchlist <- voiceid_create_watchlist

#' Deletes the specified domain from Voice ID
#'
#' @description
#' Deletes the specified domain from Voice ID.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_delete_domain/](https://www.paws-r-sdk.com/docs/voiceid_delete_domain/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain you want to delete.
#'
#' @keywords internal
#'
#' @rdname voiceid_delete_domain
voiceid_delete_domain <- function(DomainId) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$delete_domain_input(DomainId = DomainId)
  output <- .voiceid$delete_domain_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$delete_domain <- voiceid_delete_domain

#' Deletes the specified fraudster from Voice ID
#'
#' @description
#' Deletes the specified fraudster from Voice ID. This action disassociates the fraudster from any watchlists it is a part of.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_delete_fraudster/](https://www.paws-r-sdk.com/docs/voiceid_delete_fraudster/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the fraudster.
#' @param FraudsterId &#91;required&#93; The identifier of the fraudster you want to delete.
#'
#' @keywords internal
#'
#' @rdname voiceid_delete_fraudster
voiceid_delete_fraudster <- function(DomainId, FraudsterId) {
  op <- new_operation(
    name = "DeleteFraudster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$delete_fraudster_input(DomainId = DomainId, FraudsterId = FraudsterId)
  output <- .voiceid$delete_fraudster_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$delete_fraudster <- voiceid_delete_fraudster

#' Deletes the specified speaker from Voice ID
#'
#' @description
#' Deletes the specified speaker from Voice ID.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_delete_speaker/](https://www.paws-r-sdk.com/docs/voiceid_delete_speaker/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the speaker.
#' @param SpeakerId &#91;required&#93; The identifier of the speaker you want to delete.
#'
#' @keywords internal
#'
#' @rdname voiceid_delete_speaker
voiceid_delete_speaker <- function(DomainId, SpeakerId) {
  op <- new_operation(
    name = "DeleteSpeaker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$delete_speaker_input(DomainId = DomainId, SpeakerId = SpeakerId)
  output <- .voiceid$delete_speaker_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$delete_speaker <- voiceid_delete_speaker

#' Deletes the specified watchlist from Voice ID
#'
#' @description
#' Deletes the specified watchlist from Voice ID. This API throws an exception when there are fraudsters in the watchlist that you are trying to delete. You must delete the fraudsters, and then delete the watchlist. Every domain has a default watchlist which cannot be deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_delete_watchlist/](https://www.paws-r-sdk.com/docs/voiceid_delete_watchlist/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the watchlist.
#' @param WatchlistId &#91;required&#93; The identifier of the watchlist to be deleted.
#'
#' @keywords internal
#'
#' @rdname voiceid_delete_watchlist
voiceid_delete_watchlist <- function(DomainId, WatchlistId) {
  op <- new_operation(
    name = "DeleteWatchlist",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$delete_watchlist_input(DomainId = DomainId, WatchlistId = WatchlistId)
  output <- .voiceid$delete_watchlist_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$delete_watchlist <- voiceid_delete_watchlist

#' Describes the specified domain
#'
#' @description
#' Describes the specified domain.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_describe_domain/](https://www.paws-r-sdk.com/docs/voiceid_describe_domain/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_domain
voiceid_describe_domain <- function(DomainId) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_domain_input(DomainId = DomainId)
  output <- .voiceid$describe_domain_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_domain <- voiceid_describe_domain

#' Describes the specified fraudster
#'
#' @description
#' Describes the specified fraudster.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_describe_fraudster/](https://www.paws-r-sdk.com/docs/voiceid_describe_fraudster/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the fraudster.
#' @param FraudsterId &#91;required&#93; The identifier of the fraudster you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_fraudster
voiceid_describe_fraudster <- function(DomainId, FraudsterId) {
  op <- new_operation(
    name = "DescribeFraudster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_fraudster_input(DomainId = DomainId, FraudsterId = FraudsterId)
  output <- .voiceid$describe_fraudster_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_fraudster <- voiceid_describe_fraudster

#' Describes the specified fraudster registration job
#'
#' @description
#' Describes the specified fraudster registration job.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_describe_fraudster_registration_job/](https://www.paws-r-sdk.com/docs/voiceid_describe_fraudster_registration_job/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the fraudster registration
#' job.
#' @param JobId &#91;required&#93; The identifier of the fraudster registration job you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_fraudster_registration_job
voiceid_describe_fraudster_registration_job <- function(DomainId, JobId) {
  op <- new_operation(
    name = "DescribeFraudsterRegistrationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_fraudster_registration_job_input(DomainId = DomainId, JobId = JobId)
  output <- .voiceid$describe_fraudster_registration_job_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_fraudster_registration_job <- voiceid_describe_fraudster_registration_job

#' Describes the specified speaker
#'
#' @description
#' Describes the specified speaker.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_describe_speaker/](https://www.paws-r-sdk.com/docs/voiceid_describe_speaker/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the speaker.
#' @param SpeakerId &#91;required&#93; The identifier of the speaker you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_speaker
voiceid_describe_speaker <- function(DomainId, SpeakerId) {
  op <- new_operation(
    name = "DescribeSpeaker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_speaker_input(DomainId = DomainId, SpeakerId = SpeakerId)
  output <- .voiceid$describe_speaker_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_speaker <- voiceid_describe_speaker

#' Describes the specified speaker enrollment job
#'
#' @description
#' Describes the specified speaker enrollment job.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_describe_speaker_enrollment_job/](https://www.paws-r-sdk.com/docs/voiceid_describe_speaker_enrollment_job/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the speaker enrollment job.
#' @param JobId &#91;required&#93; The identifier of the speaker enrollment job you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_speaker_enrollment_job
voiceid_describe_speaker_enrollment_job <- function(DomainId, JobId) {
  op <- new_operation(
    name = "DescribeSpeakerEnrollmentJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_speaker_enrollment_job_input(DomainId = DomainId, JobId = JobId)
  output <- .voiceid$describe_speaker_enrollment_job_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_speaker_enrollment_job <- voiceid_describe_speaker_enrollment_job

#' Describes the specified watchlist
#'
#' @description
#' Describes the specified watchlist.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_describe_watchlist/](https://www.paws-r-sdk.com/docs/voiceid_describe_watchlist/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the watchlist.
#' @param WatchlistId &#91;required&#93; The identifier of the watchlist that you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_watchlist
voiceid_describe_watchlist <- function(DomainId, WatchlistId) {
  op <- new_operation(
    name = "DescribeWatchlist",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_watchlist_input(DomainId = DomainId, WatchlistId = WatchlistId)
  output <- .voiceid$describe_watchlist_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_watchlist <- voiceid_describe_watchlist

#' Disassociates the fraudsters from the watchlist specified
#'
#' @description
#' Disassociates the fraudsters from the watchlist specified. Voice ID always expects a fraudster to be a part of at least one watchlist. If you try to disassociate a fraudster from its only watchlist, a `ValidationException` is thrown.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_disassociate_fraudster/](https://www.paws-r-sdk.com/docs/voiceid_disassociate_fraudster/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the fraudster.
#' @param FraudsterId &#91;required&#93; The identifier of the fraudster to be disassociated from the watchlist.
#' @param WatchlistId &#91;required&#93; The identifier of the watchlist that you want to disassociate from the
#' fraudster.
#'
#' @keywords internal
#'
#' @rdname voiceid_disassociate_fraudster
voiceid_disassociate_fraudster <- function(DomainId, FraudsterId, WatchlistId) {
  op <- new_operation(
    name = "DisassociateFraudster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$disassociate_fraudster_input(DomainId = DomainId, FraudsterId = FraudsterId, WatchlistId = WatchlistId)
  output <- .voiceid$disassociate_fraudster_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$disassociate_fraudster <- voiceid_disassociate_fraudster

#' Evaluates a specified session based on audio data accumulated during a
#' streaming Amazon Connect Voice ID call
#'
#' @description
#' Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_evaluate_session/](https://www.paws-r-sdk.com/docs/voiceid_evaluate_session/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain where the session started.
#' @param SessionNameOrId &#91;required&#93; The session identifier, or name of the session, that you want to
#' evaluate. In Voice ID integration, this is the Contact-Id.
#'
#' @keywords internal
#'
#' @rdname voiceid_evaluate_session
voiceid_evaluate_session <- function(DomainId, SessionNameOrId) {
  op <- new_operation(
    name = "EvaluateSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$evaluate_session_input(DomainId = DomainId, SessionNameOrId = SessionNameOrId)
  output <- .voiceid$evaluate_session_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$evaluate_session <- voiceid_evaluate_session

#' Lists all the domains in the Amazon Web Services account
#'
#' @description
#' Lists all the domains in the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_list_domains/](https://www.paws-r-sdk.com/docs/voiceid_list_domains/) for full documentation.
#'
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain more pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_domains
voiceid_list_domains <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "DomainSummaries")
  )
  input <- .voiceid$list_domains_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .voiceid$list_domains_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_domains <- voiceid_list_domains

#' Lists all the fraudster registration jobs in the domain with the given
#' JobStatus
#'
#' @description
#' Lists all the fraudster registration jobs in the domain with the given `JobStatus`. If `JobStatus` is not provided, this lists all fraudster registration jobs in the given domain.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_list_fraudster_registration_jobs/](https://www.paws-r-sdk.com/docs/voiceid_list_fraudster_registration_jobs/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the fraudster registration
#' Jobs.
#' @param JobStatus Provides the status of your fraudster registration job.
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain more pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_fraudster_registration_jobs
voiceid_list_fraudster_registration_jobs <- function(DomainId, JobStatus = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFraudsterRegistrationJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "JobSummaries")
  )
  input <- .voiceid$list_fraudster_registration_jobs_input(DomainId = DomainId, JobStatus = JobStatus, MaxResults = MaxResults, NextToken = NextToken)
  output <- .voiceid$list_fraudster_registration_jobs_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_fraudster_registration_jobs <- voiceid_list_fraudster_registration_jobs

#' Lists all fraudsters in a specified watchlist or domain
#'
#' @description
#' Lists all fraudsters in a specified watchlist or domain.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_list_fraudsters/](https://www.paws-r-sdk.com/docs/voiceid_list_fraudsters/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain.
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain more pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#' @param WatchlistId The identifier of the watchlist. If provided, all fraudsters in the
#' watchlist are listed. If not provided, all fraudsters in the domain are
#' listed.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_fraudsters
voiceid_list_fraudsters <- function(DomainId, MaxResults = NULL, NextToken = NULL, WatchlistId = NULL) {
  op <- new_operation(
    name = "ListFraudsters",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "FraudsterSummaries")
  )
  input <- .voiceid$list_fraudsters_input(DomainId = DomainId, MaxResults = MaxResults, NextToken = NextToken, WatchlistId = WatchlistId)
  output <- .voiceid$list_fraudsters_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_fraudsters <- voiceid_list_fraudsters

#' Lists all the speaker enrollment jobs in the domain with the specified
#' JobStatus
#'
#' @description
#' Lists all the speaker enrollment jobs in the domain with the specified `JobStatus`. If `JobStatus` is not provided, this lists all jobs with all possible speaker enrollment job statuses.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_list_speaker_enrollment_jobs/](https://www.paws-r-sdk.com/docs/voiceid_list_speaker_enrollment_jobs/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the speaker enrollment jobs.
#' @param JobStatus Provides the status of your speaker enrollment Job.
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain more pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_speaker_enrollment_jobs
voiceid_list_speaker_enrollment_jobs <- function(DomainId, JobStatus = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSpeakerEnrollmentJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "JobSummaries")
  )
  input <- .voiceid$list_speaker_enrollment_jobs_input(DomainId = DomainId, JobStatus = JobStatus, MaxResults = MaxResults, NextToken = NextToken)
  output <- .voiceid$list_speaker_enrollment_jobs_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_speaker_enrollment_jobs <- voiceid_list_speaker_enrollment_jobs

#' Lists all speakers in a specified domain
#'
#' @description
#' Lists all speakers in a specified domain.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_list_speakers/](https://www.paws-r-sdk.com/docs/voiceid_list_speakers/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain.
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain more pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_speakers
voiceid_list_speakers <- function(DomainId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSpeakers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SpeakerSummaries")
  )
  input <- .voiceid$list_speakers_input(DomainId = DomainId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .voiceid$list_speakers_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_speakers <- voiceid_list_speakers

#' Lists all tags associated with a specified Voice ID resource
#'
#' @description
#' Lists all tags associated with a specified Voice ID resource.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/voiceid_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Voice ID resource for which you
#' want to list the tags.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_tags_for_resource
voiceid_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .voiceid$list_tags_for_resource_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_tags_for_resource <- voiceid_list_tags_for_resource

#' Lists all watchlists in a specified domain
#'
#' @description
#' Lists all watchlists in a specified domain.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_list_watchlists/](https://www.paws-r-sdk.com/docs/voiceid_list_watchlists/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain.
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain more pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_watchlists
voiceid_list_watchlists <- function(DomainId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListWatchlists",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "WatchlistSummaries")
  )
  input <- .voiceid$list_watchlists_input(DomainId = DomainId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .voiceid$list_watchlists_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_watchlists <- voiceid_list_watchlists

#' Opts out a speaker from Voice ID
#'
#' @description
#' Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_opt_out_speaker/](https://www.paws-r-sdk.com/docs/voiceid_opt_out_speaker/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the speaker.
#' @param SpeakerId &#91;required&#93; The identifier of the speaker you want opted-out.
#'
#' @keywords internal
#'
#' @rdname voiceid_opt_out_speaker
voiceid_opt_out_speaker <- function(DomainId, SpeakerId) {
  op <- new_operation(
    name = "OptOutSpeaker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$opt_out_speaker_input(DomainId = DomainId, SpeakerId = SpeakerId)
  output <- .voiceid$opt_out_speaker_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$opt_out_speaker <- voiceid_opt_out_speaker

#' Starts a new batch fraudster registration job using provided details
#'
#' @description
#' Starts a new batch fraudster registration job using provided details.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_start_fraudster_registration_job/](https://www.paws-r-sdk.com/docs/voiceid_start_fraudster_registration_job/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param DataAccessRoleArn &#91;required&#93; The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions
#' to access customer's buckets to read the input manifest file and write
#' the Job output file. Refer to the [Create and edit a fraudster
#' watchlist](https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html)
#' documentation for the permissions needed in this role.
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the fraudster registration
#' job and in which the fraudsters are registered.
#' @param InputDataConfig &#91;required&#93; The input data config containing an S3 URI for the input manifest file
#' that contains the list of fraudster registration requests.
#' @param JobName The name of the new fraudster registration job.
#' @param OutputDataConfig &#91;required&#93; The output data config containing the S3 location where Voice ID writes
#' the job output file; you must also include a KMS key ID to encrypt the
#' file.
#' @param RegistrationConfig The registration config containing details such as the action to take
#' when a duplicate fraudster is detected, and the similarity threshold to
#' use for detecting a duplicate fraudster.
#'
#' @keywords internal
#'
#' @rdname voiceid_start_fraudster_registration_job
voiceid_start_fraudster_registration_job <- function(ClientToken = NULL, DataAccessRoleArn, DomainId, InputDataConfig, JobName = NULL, OutputDataConfig, RegistrationConfig = NULL) {
  op <- new_operation(
    name = "StartFraudsterRegistrationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$start_fraudster_registration_job_input(ClientToken = ClientToken, DataAccessRoleArn = DataAccessRoleArn, DomainId = DomainId, InputDataConfig = InputDataConfig, JobName = JobName, OutputDataConfig = OutputDataConfig, RegistrationConfig = RegistrationConfig)
  output <- .voiceid$start_fraudster_registration_job_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$start_fraudster_registration_job <- voiceid_start_fraudster_registration_job

#' Starts a new batch speaker enrollment job using specified details
#'
#' @description
#' Starts a new batch speaker enrollment job using specified details.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_start_speaker_enrollment_job/](https://www.paws-r-sdk.com/docs/voiceid_start_speaker_enrollment_job/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param DataAccessRoleArn &#91;required&#93; The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions
#' to access customer's buckets to read the input manifest file and write
#' the job output file. Refer to [Batch enrollment using audio data from
#' prior
#' calls](https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html)
#' for the permissions needed in this role.
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the speaker enrollment job
#' and in which the speakers are enrolled.
#' @param EnrollmentConfig The enrollment config that contains details such as the action to take
#' when a speaker is already enrolled in Voice ID or when a speaker is
#' identified as a fraudster.
#' @param InputDataConfig &#91;required&#93; The input data config containing the S3 location for the input manifest
#' file that contains the list of speaker enrollment requests.
#' @param JobName A name for your speaker enrollment job.
#' @param OutputDataConfig &#91;required&#93; The output data config containing the S3 location where Voice ID writes
#' the job output file; you must also include a KMS key ID to encrypt the
#' file.
#'
#' @keywords internal
#'
#' @rdname voiceid_start_speaker_enrollment_job
voiceid_start_speaker_enrollment_job <- function(ClientToken = NULL, DataAccessRoleArn, DomainId, EnrollmentConfig = NULL, InputDataConfig, JobName = NULL, OutputDataConfig) {
  op <- new_operation(
    name = "StartSpeakerEnrollmentJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$start_speaker_enrollment_job_input(ClientToken = ClientToken, DataAccessRoleArn = DataAccessRoleArn, DomainId = DomainId, EnrollmentConfig = EnrollmentConfig, InputDataConfig = InputDataConfig, JobName = JobName, OutputDataConfig = OutputDataConfig)
  output <- .voiceid$start_speaker_enrollment_job_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$start_speaker_enrollment_job <- voiceid_start_speaker_enrollment_job

#' Tags a Voice ID resource with the provided list of tags
#'
#' @description
#' Tags a Voice ID resource with the provided list of tags.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_tag_resource/](https://www.paws-r-sdk.com/docs/voiceid_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Voice ID resource you want to tag.
#' @param Tags &#91;required&#93; The list of tags to assign to the specified resource.
#'
#' @keywords internal
#'
#' @rdname voiceid_tag_resource
voiceid_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .voiceid$tag_resource_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$tag_resource <- voiceid_tag_resource

#' Removes specified tags from a specified Amazon Connect Voice ID resource
#'
#' @description
#' Removes specified tags from a specified Amazon Connect Voice ID resource.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_untag_resource/](https://www.paws-r-sdk.com/docs/voiceid_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Voice ID resource you want to
#' remove tags from.
#' @param TagKeys &#91;required&#93; The list of tag keys you want to remove from the specified resource.
#'
#' @keywords internal
#'
#' @rdname voiceid_untag_resource
voiceid_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .voiceid$untag_resource_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$untag_resource <- voiceid_untag_resource

#' Updates the specified domain
#'
#' @description
#' Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an optional field, such as 'Description' is not provided, it is removed from the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_update_domain/](https://www.paws-r-sdk.com/docs/voiceid_update_domain/) for full documentation.
#'
#' @param Description A brief description about this domain.
#' @param DomainId &#91;required&#93; The identifier of the domain to be updated.
#' @param Name &#91;required&#93; The name of the domain.
#' @param ServerSideEncryptionConfiguration &#91;required&#93; The configuration, containing the KMS key identifier, to be used by
#' Voice ID for the server-side encryption of your data. Changing the
#' domain's associated KMS key immediately triggers an asynchronous process
#' to remove dependency on the old KMS key, such that the domain's data can
#' only be accessed using the new KMS key. The domain's
#' `ServerSideEncryptionUpdateDetails` contains the details for this
#' process.
#'
#' @keywords internal
#'
#' @rdname voiceid_update_domain
voiceid_update_domain <- function(Description = NULL, DomainId, Name, ServerSideEncryptionConfiguration) {
  op <- new_operation(
    name = "UpdateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$update_domain_input(Description = Description, DomainId = DomainId, Name = Name, ServerSideEncryptionConfiguration = ServerSideEncryptionConfiguration)
  output <- .voiceid$update_domain_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$update_domain <- voiceid_update_domain

#' Updates the specified watchlist
#'
#' @description
#' Updates the specified watchlist. Every domain has a default watchlist which cannot be updated.
#'
#' See [https://www.paws-r-sdk.com/docs/voiceid_update_watchlist/](https://www.paws-r-sdk.com/docs/voiceid_update_watchlist/) for full documentation.
#'
#' @param Description A brief description about this watchlist.
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the watchlist.
#' @param Name The name of the watchlist.
#' @param WatchlistId &#91;required&#93; The identifier of the watchlist to be updated.
#'
#' @keywords internal
#'
#' @rdname voiceid_update_watchlist
voiceid_update_watchlist <- function(Description = NULL, DomainId, Name = NULL, WatchlistId) {
  op <- new_operation(
    name = "UpdateWatchlist",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$update_watchlist_input(Description = Description, DomainId = DomainId, Name = Name, WatchlistId = WatchlistId)
  output <- .voiceid$update_watchlist_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$update_watchlist <- voiceid_update_watchlist
