% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_label_detection}
\alias{rekognition_start_label_detection}
\title{Starts asynchronous detection of labels in a stored video}
\usage{
rekognition_start_label_detection(
  Video,
  ClientRequestToken = NULL,
  MinConfidence = NULL,
  NotificationChannel = NULL,
  JobTag = NULL,
  Features = NULL,
  Settings = NULL
)
}
\arguments{
\item{Video}{[required] The video in which you want to detect labels. The video must be stored
in an Amazon S3 bucket.}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple
\code{\link[=rekognition_start_label_detection]{start_label_detection}} requests,
the same \code{JobId} is returned. Use \code{ClientRequestToken} to prevent the
same job from being accidently started more than once.}

\item{MinConfidence}{Specifies the minimum confidence that Amazon Rekognition Video must have
in order to return a detected label. Confidence represents how certain
Amazon Rekognition is that a label is correctly identified.0 is the
lowest confidence. 100 is the highest confidence. Amazon Rekognition
Video doesn't return any labels with a confidence level lower than this
specified value.

If you don't specify \code{MinConfidence}, the operation returns labels and
bounding boxes (if detected) with confidence values greater than or
equal to 50 percent.}

\item{NotificationChannel}{The Amazon SNS topic ARN you want Amazon Rekognition Video to publish
the completion status of the label detection operation to. The Amazon
SNS topic must have a topic name that begins with \emph{AmazonRekognition} if
you are using the AmazonRekognitionServiceRole permissions policy.}

\item{JobTag}{An identifier you specify that's returned in the completion notification
that's published to your Amazon Simple Notification Service topic. For
example, you can use \code{JobTag} to group related jobs and identify them in
the completion notification.}

\item{Features}{The features to return after video analysis. You can specify that
GENERAL_LABELS are returned.}

\item{Settings}{The settings for a StartLabelDetection request.Contains the specified
parameters for the label detection request of an asynchronous label
analysis operation. Settings can include filters for GENERAL_LABELS.}
}
\description{
Starts asynchronous detection of labels in a stored video.

See \url{https://www.paws-r-sdk.com/docs/rekognition_start_label_detection/} for full documentation.
}
\keyword{internal}
