% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_app_image_configs}
\alias{sagemaker_list_app_image_configs}
\title{Lists the AppImageConfigs in your account and their properties}
\usage{
sagemaker_list_app_image_configs(
  MaxResults = NULL,
  NextToken = NULL,
  NameContains = NULL,
  CreationTimeBefore = NULL,
  CreationTimeAfter = NULL,
  ModifiedTimeBefore = NULL,
  ModifiedTimeAfter = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of AppImageConfigs to return in the response. The
default value is 10.}

\item{NextToken}{If the previous call to \code{\link[=sagemaker_list_images]{list_images}} didn't
return the full set of AppImageConfigs, the call returns a token for
getting the next set of AppImageConfigs.}

\item{NameContains}{A filter that returns only AppImageConfigs whose name contains the
specified string.}

\item{CreationTimeBefore}{A filter that returns only AppImageConfigs created on or before the
specified time.}

\item{CreationTimeAfter}{A filter that returns only AppImageConfigs created on or after the
specified time.}

\item{ModifiedTimeBefore}{A filter that returns only AppImageConfigs modified on or before the
specified time.}

\item{ModifiedTimeAfter}{A filter that returns only AppImageConfigs modified on or after the
specified time.}

\item{SortBy}{The property used to sort results. The default value is \code{CreationTime}.}

\item{SortOrder}{The sort order. The default value is \code{Descending}.}
}
\description{
Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.

See \url{https://paws-r.github.io/docs/sagemaker/list_app_image_configs.html} for full documentation.
}
\keyword{internal}
