% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_list_medical_vocabularies}
\alias{transcribeservice_list_medical_vocabularies}
\title{Returns a list of vocabularies that match the specified criteria}
\usage{
transcribeservice_list_medical_vocabularies(NextToken, MaxResults,
  StateEquals, NameContains)
}
\arguments{
\item{NextToken}{If the result of your previous request to \code{ListMedicalVocabularies} was
truncated, include the \code{NextToken} to fetch the next set of jobs.}

\item{MaxResults}{The maximum number of vocabularies to return in the response.}

\item{StateEquals}{When specified, only returns vocabularies with the \code{VocabularyState}
equal to the specified vocabulary state.}

\item{NameContains}{Returns vocabularies in the list whose name contains the specified
string. The search is case-insensitive, \code{ListMedicalVocabularies}
returns both \"vocabularyname\" and \"VocabularyName\" in the response
list.}
}
\description{
Returns a list of vocabularies that match the specified criteria. You
get the entire list of vocabularies if you don\'t enter a value in any
of the request parameters.
}
\section{Request syntax}{
\preformatted{svc$list_medical_vocabularies(
  NextToken = "string",
  MaxResults = 123,
  StateEquals = "PENDING"|"READY"|"FAILED",
  NameContains = "string"
)
}
}

\keyword{internal}
