% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_algorithms}
\alias{sagemaker_list_algorithms}
\title{Lists the machine learning algorithms that have been created}
\usage{
sagemaker_list_algorithms(CreationTimeAfter, CreationTimeBefore,
  MaxResults, NameContains, NextToken, SortBy, SortOrder)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns only algorithms created after the specified time
(timestamp).}

\item{CreationTimeBefore}{A filter that returns only algorithms created before the specified time
(timestamp).}

\item{MaxResults}{The maximum number of algorithms to return in the response.}

\item{NameContains}{A string in the algorithm name. This filter returns only algorithms
whose name contains the specified string.}

\item{NextToken}{If the response to a previous \code{ListAlgorithms} request was truncated,
the response includes a \code{NextToken}. To retrieve the next set of
algorithms, use the token in the next request.}

\item{SortBy}{The parameter by which to sort the results. The default is
\code{CreationTime}.}

\item{SortOrder}{The sort order for the results. The default is \code{Ascending}.}
}
\description{
Lists the machine learning algorithms that have been created.
}
\section{Request syntax}{
\preformatted{svc$list_algorithms(
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  MaxResults = 123,
  NameContains = "string",
  NextToken = "string",
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending"
)
}
}

\keyword{internal}
