# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include comprehendmedical_service.R
NULL

#' Inspects the clinical text for a variety of medical entities and returns
#' specific information about them such as entity category, location, and
#' confidence score on that information
#'
#' Inspects the clinical text for a variety of medical entities and returns
#' specific information about them such as entity category, location, and
#' confidence score on that information .
#'
#' @usage
#' comprehendmedical_detect_entities(Text)
#'
#' @param Text &#91;required&#93; A UTF-8 text string containing the clinical content being examined for
#' entities. Each string must contain fewer than 20,000 bytes of
#' characters.
#'
#' @section Request syntax:
#' ```
#' svc$detect_entities(
#'   Text = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_detect_entities
comprehendmedical_detect_entities <- function(Text) {
  op <- new_operation(
    name = "DetectEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$detect_entities_input(Text = Text)
  output <- .comprehendmedical$detect_entities_output()
  svc <- .comprehendmedical$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$detect_entities <- comprehendmedical_detect_entities

#' Inspects the clinical text for personal health information (PHI)
#' entities and entity category, location, and confidence score on that
#' information
#'
#' Inspects the clinical text for personal health information (PHI)
#' entities and entity category, location, and confidence score on that
#' information.
#'
#' @usage
#' comprehendmedical_detect_phi(Text)
#'
#' @param Text &#91;required&#93; A UTF-8 text string containing the clinical content being examined for
#' PHI entities. Each string must contain fewer than 20,000 bytes of
#' characters.
#'
#' @section Request syntax:
#' ```
#' svc$detect_phi(
#'   Text = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname comprehendmedical_detect_phi
comprehendmedical_detect_phi <- function(Text) {
  op <- new_operation(
    name = "DetectPHI",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .comprehendmedical$detect_phi_input(Text = Text)
  output <- .comprehendmedical$detect_phi_output()
  svc <- .comprehendmedical$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.comprehendmedical$operations$detect_phi <- comprehendmedical_detect_phi
