% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_describe_pipeline_execution}
\alias{sagemaker_describe_pipeline_execution}
\title{Describes the details of a pipeline execution}
\usage{
sagemaker_describe_pipeline_execution(PipelineExecutionArn)
}
\arguments{
\item{PipelineExecutionArn}{[required] The Amazon Resource Name (ARN) of the pipeline execution.}
}
\value{
A list with the following syntax:\preformatted{list(
  PipelineArn = "string",
  PipelineExecutionArn = "string",
  PipelineExecutionDisplayName = "string",
  PipelineExecutionStatus = "Executing"|"Stopping"|"Stopped"|"Failed"|"Succeeded",
  PipelineExecutionDescription = "string",
  CreationTime = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTime = as.POSIXct(
    "2015-01-01"
  ),
  CreatedBy = list(
    UserProfileArn = "string",
    UserProfileName = "string",
    DomainId = "string"
  ),
  LastModifiedBy = list(
    UserProfileArn = "string",
    UserProfileName = "string",
    DomainId = "string"
  )
)
}
}
\description{
Describes the details of a pipeline execution.
}
\section{Request syntax}{
\preformatted{svc$describe_pipeline_execution(
  PipelineExecutionArn = "string"
)
}
}

\keyword{internal}
