% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexruntimeservice_operations.R
\name{lexruntimeservice_get_session}
\alias{lexruntimeservice_get_session}
\title{Returns session information for a specified bot, alias, and user ID}
\usage{
lexruntimeservice_get_session(botName, botAlias, userId,
  checkpointLabelFilter)
}
\arguments{
\item{botName}{[required] The name of the bot that contains the session data.}

\item{botAlias}{[required] The alias in use for the bot that contains the session data.}

\item{userId}{[required] The ID of the client application user. Amazon Lex uses this to identify
a user's conversation with your bot.}

\item{checkpointLabelFilter}{A string used to filter the intents returned in the
\code{recentIntentSummaryView} structure.

When you specify a filter, only intents with their \code{checkpointLabel}
field set to that string are returned.}
}
\description{
Returns session information for a specified bot, alias, and user ID.
}
\section{Request syntax}{
\preformatted{svc$get_session(
  botName = "string",
  botAlias = "string",
  userId = "string",
  checkpointLabelFilter = "string"
)
}
}

\keyword{internal}
